\name{fixedSampsize}
\alias{fixedSampsize}
\title{Fixed model sample size for a gsearly model}
\usage{fixedSampsize(mod, pow=NULL, direct="u", signif=3)}
\description{Calculates the fixed model sample size, assuming no correlation
   between early and final outcomes, for a fitted gsearly model, from functions
   \code{gsearlyModel} or \code{gsearlyUser}.}
\arguments{
 \item{mod}{A gsearly model.}
 \item{pow}{Power is set to a value between 0 and 1, or if unset is taken from
    \code{mod}.}
 \item{direct}{Rounds sample sizes to nearest integer, upwards \code{"u"} (using
     \code{ceiling}) or downwards \code{"d"} (using \code{floor})}
 \item{signif}{Rounds power to the specified number of significant digits.}
}
\value{
 Returns a list with the following items.
 \item{n}{Sample size for the control and treatment groups and total.}
 \item{power}{Study power.}
}
\seealso{
 \code{\link{gsearlyModel}}, \code{\link{gsearlyUser}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="fix", trecruit=36, s=3, tfu=c(3,6,12),
              tinterims=c(16,31), pow=0.8, cmodel="exponential", sd=20,
              rho=0.75, theta=8, fp=fp, tn=tn)
 fixedSampsize(rctdesign)

}
