\name{modelParameters}
\alias{modelParameters}
\title{Estimates model parameters from raw data}
\usage{modelParameters(data, datanames=c("id", "atime", "intervention", "outcome"),
              vcovmat)}
\description{Provides estimates of the variance of beta (vbeta) and beta, the
  treatment effect, directly from raw data and a user supplied covariance
  matrix.}
\arguments{
 \item{data}{A data frame structured as those from function
   \code{\link{simdataExtract}}, with \code{full=TRUE}, but without the
   requirement for a standardized (continuous) time-point
   (see \code{\link{tfuStandard}}).}
 \item{datanames}{Names of the four variables in the data frame \code{data} that
   are respectively participant id, time-point, intervention arm and outcome, in
   that order.}
 \item{vcovmat}{A covariance matrix of dimensions \code{s x s}.}
}
\value{
 Returns the variance of beta (vbeta), beta and test statistic z.
}
\seealso{
 \code{\link{gsearlySimulate}}, \code{\link{simdataExtract}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.2400,0.7200,0.9750)
 modeldesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(18,30), pow=0.9, vphi=0.5, m=2,
                   cmodel="uniform", sd=20, rho=0.5, theta=8, fp=fp, tn=tn)

 # Simulate data from this model with raw data using full=TRUE
 simdata <- gsearlySimulate(mod=modeldesign, nsim=10, full=TRUE)

 # Extract raw data for a single simulation
 simdat1 <- simdataExtract(simdata, simn=1, tinterims=18, full=TRUE)
 # Get model parameters
 modelParameters(data=simdat1$data, vcovmat=simdat1$model$covariance)

 # Try alternative covariance model
 varmat <- diag(c(18,22,24))
 vcovmat <- tcrossprod(crossprod(varmat,corrExp(rho=0.8,
                                            tfu=simdat1$model$tfu)),varmat)
 modelParameters(data=simdat1$data, vcovmat=vcovmat)

}
