\name{summary.gsearly}
\alias{summary.gsearly}
\title{Summarise a gsearly model}
\usage{
\method{summary}{gsearly}(object, ...)
}
\description{Provides a summary of a gsearly model.}
\arguments{
 \item{object}{A fitted gsearly object from function \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
 \item{...}{Further arguments passed to function (not currently implemented).}
}
\value{
 A gsearly model summary.
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8,
                   cmodel="exponential", sd=20, rho=0.75, theta=8, fp=fp, tn=tn)
 summary(rctdesign)
 str(summary(rctdesign))

}
