% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_remd.R
\name{hanr_remd}
\alias{hanr_remd}
\title{Anomaly detector using REMD}
\usage{
hanr_remd(noise = 0.1, trials = 5)
}
\arguments{
\item{noise}{nosie}

\item{trials}{trials}
}
\value{
\code{hanr_remd} object
}
\description{
Anomaly detection using REMD
The EMD model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the EMD model presented in the forecast library.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure REMD detector
model <- hanr_remd()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Souza, J., Paixão, E., Fraga, F., Baroni, L., Alves, R. F. S., Belloze, K., Dos Santos, J.,
Bezerra, E., Porto, F., Ogasawara, E. REMD: A Novel Hybrid Anomaly Detection Method Based on
EMD and ARIMA. Proceedings of the International Joint Conference on Neural Networks, 2024.
doi:10.1109/IJCNN60899.2024.10651192
}
}
