% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo.R
\name{censo_sidra_data}
\alias{censo_sidra_data}
\title{Get Census data from SIDRA API}
\usage{
censo_sidra_data(
  table,
  territorial_level = "brazil",
  geo_code = "all",
  year = NULL,
  variable = NULL,
  classifications = NULL,
  raw = FALSE
)
}
\arguments{
\item{table}{Numeric or character. SIDRA table code.
Use \code{\link{censo_sidra_tables}} or \code{\link{censo_sidra_search}}
to find codes.}

\item{territorial_level}{Character. Geographic level:
\code{"brazil"} (N1), \code{"region"} (N2), \code{"state"} (N3),
\code{"municipality"} (N6). Default \code{"brazil"}.}

\item{geo_code}{Character. IBGE code(s) for specific localities.
\code{"all"} returns all localities at the chosen level. Default
\code{"all"}.}

\item{year}{Numeric or character. Year(s) to query. NULL returns all
available periods.}

\item{variable}{Numeric or character. SIDRA variable ID(s).
NULL returns all variables excluding metadata. Default NULL.}

\item{classifications}{Named list. SIDRA classification filters.
Example: \code{list("2" = "allxt")} for sex breakdown.
NULL returns default aggregation. Default NULL.}

\item{raw}{Logical. If TRUE, returns raw API output without cleaning.
Default FALSE.}
}
\value{
A tibble with queried data.
}
\description{
Queries the IBGE SIDRA API to retrieve any Census table. This is the
most flexible function, allowing full control over SIDRA query parameters.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# population by state from 2022 Census
censo_sidra_data(
  table = 9514,
  territorial_level = "state",
  year = 2022,
  variable = 93
)

# population by race, Brazil level
censo_sidra_data(
  table = 9605,
  territorial_level = "brazil",
  year = 2022,
  variable = 93,
  classifications = list("86" = "allxt")
)
\dontshow{\}) # examplesIf}
}
