% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare the attributable health impacts between two scenarios}
\usage{
compare(
  output_attribute_scen_1,
  output_attribute_scen_2,
  approach_comparison = "delta"
)
}
\arguments{
\item{output_attribute_scen_1}{Scenario 1 as in the output of attribute()}

\item{output_attribute_scen_2}{Scenario 2 as in the output of attribute()}

\item{approach_comparison}{\code{String} showing the method of comparison. Options: "delta" or "pif".}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the main results from the comparison;
\itemize{
 \item \code{impact} (\code{numeric} column) difference in attributable health burden/impact between scenario 1 and 2
 \item \code{impact_scen_1} (\code{numeric} column) attributable health impact of scenario 1
 \item \code{impact_scen_2} (\code{numeric} column) attributable health impact of scenario 2
 \item And many more
 }

2) \code{health_detailed} (\code{list}) containing detailed (and interim) results from the comparison.
\itemize{
 \item \code{results_raw} (\code{tibble}) containing comparison results for each combination of input uncertainty for both scenario 1 and 2
 \item \code{results_by_geo_id_micro} (\code{tibble}) containing comparison results for each geographic unit under analysis (specified in \code{geo_id_micro} argument)
 \item \code{results_by_geo_id_macro} (\code{tibble}) containing comparison results for each aggregated geographic unit under analysis (specified in \code{geo_id_macro} argument))
 \item \code{input_table} (\code{list}) containing the inputs to each relevant argument for both scenario 1 and 2
 \item \code{input_args} (\code{list}) containing all the argument inputs for both scenario 1 and 2 used in the background
 \item \code{scen_1} (\code{tibble}) containing results for scenario 1
 \item \code{scen_2} (\code{tibble}) containing results for scenario 2
 }
}
\description{
This function calculates the health impacts between two scenarios (e.g. before and after a intervention in a health impact assessments) using either the delta or pif approach.
}
\details{
Note that the PIF comparison approach assumes same baseline health data for scenario 1 and 2 (e.g. comparison of two scenarios at the same time).

\strong{Equations population impact fraction (PIF)}

The Population Impact Fraction (PIF) is defined as the proportional change in disease or mortality when exposure to a risk factor is changed (for instance due to an intervention). The most general equation describing this mathematically is an integral form (WHO 2003a, https://www.who.int/publications/i/item/9241546204; WHO 2003b, https://doi.org/10.1186/1478-7954-1-1):
\deqn{PIF = \frac{\int RR(x)PE(x)dx - \int RR(x)PE'(x)dx}{\int RR(x)PE(x)dx}}

Where:

x     = exposure level

PE(x) = population distribution of exposure

PE'(x) = alternative population distribution of exposure

RR(x) = relative risk at exposure level compared to the reference level

If the population exposure is described as a categorical rather than continuous exposure, the integrals in equation (5) may be converted to sums, resulting in the following equations for the PIF (WHO 2003a, https://www.who.int/publications/i/item/9241546204; WHO 2003b, https://doi.org/10.1186/1478-7954-1-1):
\deqn{PIF = \frac{\sum RR_{i} \times PE_{i} - \sum RR_{i}PE'_{i}}{\sum RR_{i}PE_{i}}}

Where:

i     = is the exposure category (e.g. in bins of 1 \eqn{\mu g/m^3} PM2.5 or 5 dB noise exposure)

\eqn{PE_i} = fraction of population in exposure category i

\eqn{PE'_i} = fraction of population in category i for alternative (ideal) exposure scenario

\eqn{RR_i} = relative risk for exposure category level i compared to the reference level

Finally, if the exposure is provided as the population weighted mean concentration (PWC), the equation for the PIF is reduced to:
\deqn{PIF = \frac{RR_{PWC} - RR_{alt PWC}}{RR_{PWC}}}

Where:

\eqn{RR_{PWC}} = relative risk associated with the population weighted mean exposure

\eqn{RR_{PWC}} = relative risk associated with the population weighted mean for the alternative exposure scenario

\strong{Delta comparison approach}

With the delta comparison the difference between two scenarios is obtained by subtraction. The delta approach is suited for all comparison cases, and specifically for comparison of a situation now with a situation in the future.
}
\examples{
# Goal: comparison of two scenarios with delta approach
scenario_A <- attribute_health(
  exp_central = 8.85,   # EXPOSURE 1
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118,
  rr_increment = 10
)
scenario_B <- attribute_health(
  exp_central = 6,     # EXPOSURE 2
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118,
  rr_increment = 10
)
results <- compare(
approach_comparison = "delta",
output_attribute_scen_1 = scenario_A,
output_attribute_scen_2 = scenario_B
)
# Inspect the difference, stored in the \code{impact} column
results$health_main |>
  dplyr::select(impact, impact_scen_1, impact_scen_2) |>
  print()

# Goal: comparison of two scenarios with population impact fraction (pif) approach
output_attribute_scen_1 <- attribute_health(
  exp_central = 8.85,   # EXPOSURE 1
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118, rr_lower = 1.060, rr_upper = 1.179,
  rr_increment = 10
)
output_attribute_scen_2 <- attribute_health(
  exp_central = 6,      # EXPOSURE 2
  cutoff_central = 5,
  bhd_central = 25000,
  approach_risk = "relative_risk",
  erf_shape = "log_linear",
  rr_central = 1.118, rr_lower = 1.060, rr_upper = 1.179,
  rr_increment = 10
)
results <- compare(
  output_attribute_scen_1 = output_attribute_scen_1,
  output_attribute_scen_2 = output_attribute_scen_2,
  approach_comparison = "pif"
)
# Inspect the difference, stored in the impact column
results$health_main$impact
}
\author{
Alberto Castro & Axel Luyten
}
