% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_points.R
\name{labelPoints}
\alias{labelPoints}
\title{Label points in a ggplot object}
\usage{
labelPoints(
  p,
  labelDF,
  pointLabs = rownames(labelDF),
  labelType = c("free", "boxed"),
  labelSize = 2.5,
  labelColor = "black",
  labelRepulsion = 1,
  labelPull = 1,
  maxOverlaps = 50,
  boxPadding = 0.2,
  labelPadding = 0.1,
  labelSegWidth = 0.4,
  ...
)
}
\arguments{
\item{p}{A ggplot object.}

\item{labelDF}{Label data frame.}

\item{pointLabs}{Labels of points.}

\item{labelType}{Whether to draw a box around labels (option 'boxed') or not
(option 'free'). Default is 'free'.}

\item{labelSize}{Label size.}

\item{labelColor}{Label color.}

\item{labelRepulsion}{Repulsion strength between labels.}

\item{labelPull}{Attraction strength between a text label
and its data point.}

\item{maxOverlaps}{Maximum number of allowed overlaps.}

\item{boxPadding}{Amount of padding around box.}

\item{labelPadding}{Amount of padding around label.}

\item{labelSegWidth}{Thickness of segment connecting label to point.}

\item{...}{Additional arguments passed to \code{geom_text_repel}
(if \code{labelType} is 'free') or \code{geom_text_label}
(if \code{labelType} is 'boxed').}
}
\value{
A ggplot object.
}
\description{
This function labels points in a ggplot object.
}
\examples{
filePath <- system.file('extdata', 'hullPlot.qs2', package='henna')
sharedDF <- qs2::qs_read(filePath)
name1 <- 'alpha'
name2 <- 'delta'
legendLabs <- as.factor(c('Non-top',
'Shared',
paste0('Top only for ', name2),
paste0('Top only for ', name1)))
p <- hullPlot(sharedDF, 'Shared markers plot', xInt=1.5, yInt=1.3,
xLab=paste0('avg_log2FC (', name1, ')'),
yLab=paste0('avg_log2FC (', name2, ')'),
legendLabs=legendLabs)
labelDF <- sharedDF[sharedDF[, 'avg_log2FC_1'] > 1.5 &
sharedDF[, 'avg_log2FC_2'] > 1.3, ]
p <- labelPoints(p, labelDF, labelType='boxed', nudge_x=0.1, nudge_y=0.1)

}
