% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_plot.R
\name{tilePlot}
\alias{tilePlot}
\title{Plot a numeric matrix or data frame}
\usage{
tilePlot(
  mat,
  title = NULL,
  xLab = NULL,
  yLab = NULL,
  legendTitle = "Value",
  palette = "Spectral",
  reverseColors = TRUE,
  sigDigits = 2,
  isCor = FALSE,
  labelSize = 3,
  labelColor = "black",
  legendTextSize = 10,
  legendTitleSize = 10,
  axisTextSize = 12,
  axisTitleSize = 12,
  tileBoundaryColor = "white",
  tileBoundaryWidth = 0.2,
  xAngle = 45,
  vJust = 0.6,
  ...
)
}
\arguments{
\item{mat}{A numeric matrix or data frame.}

\item{title}{Plot title.}

\item{xLab}{x axis label.}

\item{yLab}{y axis label.}

\item{legendTitle}{Legend title.}

\item{palette}{Color palette.}

\item{reverseColors}{Whether to reverse the order of colors in the palette.}

\item{sigDigits}{Number of significant digits to be displayed for each
matrix element.}

\item{isCor}{Whether the matrix is a correlation matrix, in which case the
limits of the color scale will be set to [-1, 1].}

\item{labelSize}{Label size.}

\item{labelColor}{Label color.}

\item{legendTextSize}{Legend text size.}

\item{legendTitleSize}{Legend title size.}

\item{axisTextSize}{Axis text size.}

\item{axisTitleSize}{Axis title size.}

\item{tileBoundaryColor}{Tile boundary color.}

\item{tileBoundaryWidth}{Tile boundary width.}

\item{xAngle}{Angle of x axis text.}

\item{vJust}{Vertical justification in [0, 1].}

\item{...}{Additional arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function plots a numeric matrix or data frame.
}
\examples{
mat <- matrix(round(runif(100, 0, 1), 2), nrow=10)
rownames(mat) <- paste0('R', seq(10))
colnames(mat) <- paste0('C', seq(10))
tilePlot(mat)

}
