% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPegelonlineW.R
\name{getPegelonlineW}
\alias{getPegelonlineW}
\title{Get W from pegelonline.wsv.de for the specified gauging station and
  time}
\usage{
getPegelonlineW(gauging_station, time, uuid)
}
\arguments{
\item{gauging_station}{must be type \code{character} with a length of one. Permitted values are: 'SCHOENA', 'PIRNA', 'DRESDEN', 'MEISSEN', 'RIESA', 'MUEHLBERG', 'TORGAU', 'PRETZSCH-MAUKEN', 'ELSTER', 'WITTENBERG', 'COSWIG', 'VOCKERODE', 'ROSSLAU', 'DESSAU', 'AKEN', 'BARBY', 'SCHOENEBECK', 'MAGDEBURG-BUCKAU', 'MAGDEBURG-STROMBRUECKE', 'MAGDEBURG-ROTHENSEE', 'NIEGRIPP AP', 'ROGAETZ', 'TANGERMUENDE', 'STORKAU', 'SANDAU', 'SCHARLEUK', 'WITTENBERGE', 'MUEGGENDORF', 'SCHNACKENBURG', 'LENZEN', 'GORLEBEN', 'DOEMITZ', 'DAMNATZ', 'HITZACKER', 'NEU DARCHAU', 'BLECKEDE', 'BOIZENBURG', 'HOHNSTORF', 'ARTLENBURG', 'GEESTHACHT', 'WEHR GEESTHACHT UP', 'ALTENGAMME', 'ZOLLENSPIEKER', 'BUNTHAUS', 'HAMBURG ST. PAULI', 'SEEMANNSHOEFT', 'BLANKENESE UF', 'SCHULAU', 'LUEHORT', 'STADERSAND', 'KOLLMAR', 'GLUECKSTADT', 'BROKDORF', 'BRUNSBUETTEL MPM', 'OSTERIFF MPM', 'OTTERNDORF MPM', 'CUXHAVEN STEUBENHOEFT', 'MITTELGRUND', 'SCHARHOERN', 'BAKE Z', 'HERBRUM HAFENDAMM', 'RHEDE', 'PAPENBURG', 'WEENER', 'LEERORT', 'TERBORG', 'POGUM', 'EMDEN NEUE SEESCHLEUSE', 'KNOCK', 'DUKEGAT', 'EMSHOERN', 'BORKUM FISCHERBALJE', 'NORDERNEY RIFFGAT', 'LANGEOOG', 'SPIEKEROOG', 'IFFEZHEIM', 'PLITTERSDORF', 'MAXAU', 'PHILIPPSBURG', 'SPEYER', 'MANNHEIM', 'WORMS', 'NIERSTEIN-OPPENHEIM', 'MAINZ', 'OESTRICH', 'BINGEN', 'KAUB', 'SANKT GOAR', 'BOPPARD', 'BRAUBACH', 'KOBLENZ', 'ANDERNACH', 'OBERWINTER', 'BONN', 'KOELN', 'DUESSELDORF', 'RUHRORT', 'WESEL', 'REES', 'EMMERICH', 'GROENHUDE', 'BREITENBERG', 'ITZEHOE HAFEN', 'STOER-SPERRWERK BP'.}

\item{time}{must be type \code{c("POSIXct", "POSIXt")} or \code{Date} and
be in the  temporal range between 31 days ago
\code{\link[base:Sys.time]{Sys.time()} - 2678400} or
\code{\link[base:Sys.time]{Sys.Date()} - 31} and now
(\code{\link[base:Sys.time]{Sys.time()}}) or yesterday
(\code{\link[base:Sys.time]{Sys.Date()} - 1}).}

\item{uuid}{must be type \code{character} with a length of one. Permitted values are: '7cb7461b-3530-4c01-8978-7f676b8f71ed', '85d686f1-55b2-4d36-8dba-3207b50901a7', '70272185-b2b3-4178-96b8-43bea330dcae', '24440872-5bd2-4fb3-8554-907b49816c49', 'b04b739d-7ffa-41ee-9eb9-95cb1b4ef508', '16b9b4e7-be14-41fd-941e-6755c97276cc', '83bbaedb-5d81-4bc6-9f66-3bd700c99c1f', 'f3dc8f07-c2bb-4b92-b0b0-4e01a395a2c6', 'c093b557-4954-4f05-8f5c-6c6d7916c62d', '070b1eb4-3872-4e07-b2e5-e25fd9251b93', '1ce53a59-33b9-40dc-9b17-3cd2a2414607', 'ae93f2a5-612e-4514-b5fd-9c8aecdd73c7', 'e97116a4-7d30-4671-8ba1-cdce0a153d1d', '1edc5fa4-88af-47f5-95a4-0e77a06fe8b1', '094b96e5-caeb-46d3-a8ee-d44182add069', '939f82ec-15a9-49c8-8828-dc2f8a2d49e2', '90bcb315-f080-41a8-a0ac-6122331bb4cf', 'b8567c1e-8610-4c2b-a240-65e8a74919fa', 'ccccb57f-a2f9-4183-ae88-5710d3afaefd', 'e30f2e83-b80b-4b96-8f39-fa60317afcc7', '3adf88fd-fd7a-41d0-84f5-1143c98a6564', '133f0f6c-2ca1-4798-9360-5b5f417dd839', '13e91b77-90f3-41a5-a320-641748e9c311', 'de4cc1db-51cb-4b62-bee2-9750cbe4f5c4', 'f4c55f77-ab80-4e00-bed3-aa6631aba074', 'e32b0a28-8cd5-4053-bc86-fff9c6469106', 'cbf3cd49-91bd-49cc-8926-ccc6c0e7eca4', '48f2661f-f9cb-4093-9d57-da2418ed656e', '550e3885-a9d1-4e55-bd25-34228bd6d988', 'c80a4f21-528c-4771-98d7-10cd591699a4', 'ac507f42-1593-49ea-865f-10b2523617c7', '6e3ea719-48b1-408a-bc55-0986c1e94cd5', 'c233674f-259a-4304-b81f-dce1f415d85b', 'a26e57c9-1cb8-4fca-ba80-9e02abc81df8', '67d6e882-b60c-40d3-975c-a6d7a2b4e40a', '6aa1cd8e-e528-4bcb-ba8e-705b6dcb7da2', '33e0bce0-13df-4ffc-be9d-f1a79e795e1c', 'd9289367-c8aa-4b6a-b1ad-857fec94c6bb', 'b3492c68-8373-4769-9b29-22f66635a478', '44f7e955-c97d-45c8-9ed7-19406806fb4c', '0f7f58a8-411f-43d9-b42a-e897e63c4faa', '2ee12b9a-f7fd-4856-82b9-6bdd850c2bba', '3de8ea26-ab29-4e46-adad-06198ba2e0b7', 'ae1b91d0-e746-4f65-9f64-2d2e23603a82', 'd488c5cc-4de9-4631-8ce1-0db0e700b546', '816affba-0118-4668-887f-fb882ed573b2', 'bacb459b-0f24-4233-bb35-cd224a51678e', 'f3c6ee73-5561-4068-96ec-364016e7d9ef', '8d18d129-07f1-4c4d-adba-a985016be0b0', '80f0fc4d-9fc7-449d-9d68-ee89333f0eff', '3ed90357-4b01-4119-b1c5-bd2c62871e7b', '1f1bbed7-c1fa-45b4-90d3-df94b50ad631', '610ab204-d3c4-4a11-a38b-e31461fdcf27', 'd4f5f719-8c52-4f8d-945d-1c31404cc628', 'eb90bd3f-5405-412d-81e0-7a58be52dcef', '5140295e-b93e-4081-a920-642d89c7ca8b', 'aad49293-242a-43ad-a8b1-e91d7792c4b2', '3ff99b92-4396-4fa7-af73-02b9c015dcad', 'f0197bcf-6846-4c0a-9659-0c2626a9bcf0', '104fdc24-1dc6-4cb7-b44f-10bd02e13f40', '8177a148-5674-4b8f-8ded-050907f640f3', '16508b11-4349-48f7-be51-1227b7888585', 'ec4a598d-773d-44c1-935e-2053b54e45a3', 'aa6af4e6-a44f-46c4-abf6-449f8a68bab1', 'abb23dad-0880-41ab-8d2d-dd33e11f148f', '244cae8b-ce75-4c2d-a66e-cb804f8335a2', '5d1e4350-0f39-4428-84c3-6f8f0bbe80d4', 'edfdf747-be92-462f-87ed-53d228a33172', '438b565e-f293-43c8-8771-377e555ed5ec', '7753c1fa-34d8-4d09-a7c7-38024079117c', 'c8af067c-ba6a-4a76-86d8-1ce8e532ef8b', '8727ebfd-e2e1-43da-ab3d-fee48cff9acc', 'c0244c0e-6ae6-40cb-a967-4039b2a0ce7c', 'a0c1dcb6-7812-48e6-8c01-f7edad7a2caf', '662c4b5e-0241-456d-ac7d-9f62fd95c0d1', 'b02be240-1364-4c97-8bb6-675d7d842332', '6b774802-fcb5-49ae-8ecb-ecaf1a278b1c', 'b6c6d5c8-e2d5-4469-8dd8-fa972ef7eaea', '88e972e1-88a0-4eb9-847c-0925e5999a46', '2cb8ae5b-c5c9-4fa8-bac0-bb724f2754f4', '57090802-c51a-4d09-8340-b4453cd0e1f5', '844a620f-f3b8-4b6b-8e3c-783ae2aa232a', 'd28e7ed1-3317-41c5-bec6-725369ed1171', 'a37a9aa3-45e9-4d90-9df6-109f3a28a5af', '665be0fe-5e38-43f6-8b04-02a93bdbeeb4', '0309cd61-90c9-470e-99d4-2ee4fb2c5f84', '1d26e504-7f9e-480a-b52c-5932be6549ab', '550eb7e9-172e-48e4-ae1e-d1b761b42223', '2ff6379d-d168-4022-8da0-16846d45ef9b', 'd6dc44d1-63ac-4871-b175-60ac4040069a', '4c7d796a-39f2-4f26-97a9-3aad01713e29', '5735892a-ec65-4b29-97c5-50939aa9584e', 'b45359df-c020-4314-adb1-d1921db642da', '593647aa-9fea-43ec-a7d6-6476a76ae868', 'a6ee8177-107b-47dd-bcfd-30960ccc6e9c', '8f7e5f92-1153-4f93-acba-ca48670c8ca9', 'c0f51e35-d0e8-4318-afaf-c5fcbc29f4c1', 'f33c3cc9-dc4b-4b77-baa9-5a5f10704398', '2f025389-fac8-4557-94d3-7d0428878c86', '9598e4cb-0849-401e-bba0-689234b27644', '15859426-834c-429e-9c41-2e097b717b1d', '24c6a014-864b-4d53-bd05-0b49106f5412', 'd863cbc3-5e5e-4095-855c-026f0850dd58', 'e5b8e9f3-f0cc-4ad7-8707-577ee1b25b3e'.}
}
\value{
The returned output depends on the type of the input parameter
  \code{time}. If \code{time} is type
  \code{\link[base:POSIXct]{c("POSIXct", "POSIXt")}} the
  returned object contains queried and interpolated water levels. If
  \code{time} is type \code{Date} the returned object contains daily averaged
  water levels.
}
\description{
Download and temporarily interpolate or average water level data
  from \url{https://pegelonline.wsv.de/gast/start}.
}
\details{
This functions queries online water level data through the
  \href{https://en.wikipedia.org/wiki/Representational_state_transfer}{REST}
  service of \href{https://pegelonline.wsv.de/gast/start}{PEGELONLINE}. The
  gauging data from \href{https://pegelonline.wsv.de/gast/start}{PEGELONLINE}
  have a high temporal resolution of 15 minutes, enabling meaningful linear
  temporal interpolation if \code{time} is supplied with type
  \code{\link[base:POSIXct]{c("POSIXct", "POSIXt")}}. If \code{time} is
  supplied with type \code{Date} water level data are aggregated to daily
  averages.
  
  Since data from \href{https://pegelonline.wsv.de/gast/start}{PEGELONLINE}
  expire after 31 days, this function is only applicable to query unvalidated
  water level values for the last 31 days before function call. If you need
  older and validated data, feel free to contact the data service at the
  Federal Institute of Hydrology by email (\email{Datenstelle-M1@bafg.de}).
}
\examples{
\dontshow{if (hyd1d:::.pegelonline_status()) withAutoprint(\{ # examplesIf}
   getPegelonlineW(gauging_station = "DESSAU", time = Sys.time() - 3600)
   getPegelonlineW(gauging_station = "DESSAU", time = Sys.Date() - 1)
\dontshow{\}) # examplesIf}
}
\references{
\insertRef{wsv_pegelonline_2018}{hyd1d}
}
\seealso{
\code{\link{waterLevelPegelonline}}
}
