% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_iARclass.R
\name{iAR}
\alias{iAR}
\title{`iAR` Class}
\usage{
iAR(
  times = integer(0),
  series = integer(0),
  series_esd = integer(0),
  series_names = character(0),
  family = "norm",
  fitted_values = integer(0),
  loglik = integer(0),
  kalmanlik = integer(0),
  coef = 0.9,
  df = 3,
  sigma = 1,
  mean = 0,
  variance = 1,
  tAhead = 1,
  forecast = integer(0),
  interpolated_values = integer(0),
  interpolated_times = integer(0),
  interpolated_series = integer(0),
  zero_mean = TRUE,
  standardized = TRUE,
  hessian = FALSE,
  summary = list()
)
}
\arguments{
\item{times}{A numeric vector representing the time points.}

\item{series}{A numeric vector representing the values of the time series.}

\item{series_esd}{A numeric vector representing the error standard deviations of the time series.}

\item{series_names}{An optional character vector of length 1 representing the name of the series.}

\item{family}{A character string indicating the distribution family of the model. Must be one of `"norm"`, `"t"`, or `"gamma"`. Defaults to `"norm"`.}

\item{fitted_values}{A numeric vector containing the fitted values from the model.}

\item{loglik}{A numeric value representing the log-likelihood of the model.}

\item{kalmanlik}{A numeric value representing the Kalman likelihood of the model.}

\item{coef}{A numeric vector containing the estimated coefficients of the model (default: 0.9).}

\item{df}{A numeric value representing the degrees of freedom (`t` distribution) (default: 3).}

\item{sigma}{A numeric value representing the scale parameter (`t` distribution) (default: 1).}

\item{mean}{A numeric value representing the estimated mean of the model (`gamma` parameter).}

\item{variance}{A numeric value representing the estimated variance of the model (`gamma` parameter).}

\item{tAhead}{A numeric value specifying the forecast horizon (default: 1).}

\item{forecast}{A numeric vector containing the forecasted values.}

\item{interpolated_values}{A numeric vector containing the interpolated values.}

\item{interpolated_times}{A numeric vector containing the times of the interpolated data points.}

\item{interpolated_series}{A numeric vector containing the interpolated series.}

\item{zero_mean}{A logical value indicating if the model assumes a zero-mean process (default: TRUE).}

\item{standardized}{A logical value indicating if the model assumes a standardized process (default: TRUE).}

\item{hessian}{A logical value indicating whether the Hessian matrix is computed during estimation (default: FALSE).}

\item{summary}{A list containing the summary of the model fit, including diagnostics and statistical results.}
}
\description{
Represents a univariate irregular autoregressive (iAR) time series model. 
This class extends the "unidata" class and includes additional properties 
for modeling, forecasting, and interpolation.
}
\details{
The `iAR` class is designed to handle irregularly observed time series data using an 
autoregressive approach. It extends the "unidata" class to include additional 
modeling and diagnostic capabilities. Key functionalities include forecasting, 
interpolation, and model fitting.

The class also supports advanced modeling features, such as:
- Different distribution families for the data (e.g., Gaussian, `t`-distribution).
- Optional computation of the Hessian matrix for parameter estimation.
- Standardized or zero-mean process assumptions.
}
\section{Validation Rules}{

- Inherits all validation rules from the `unidata` class:
 - `@times`, `@series`, and `@series_esd` must be numeric vectors.
 - `@times` must not contain `NA` values and must be strictly increasing.
 - The length of `@series` must match the length of `@times`.
 - The length of `@series_esd` must be 0, 1, or equal to the length of `@series`.
 - `NA` values in `@series` must correspond exactly (positionally) to `NA` values in `@series_esd`.
 - `@series_names`, if provided, must be a character vector of length 1.

- `@family` must be one of `"norm"`, `"t"`, or `"gamma"`.
- `@coef` must be a numeric scalar strictly between 0 and 1.
- `@df` must be a positive integer scalar **only if** `family = "t"`; otherwise, it should not be specified.
- `@sigma` must be a strictly positive numeric scalar (used in `"t"` family).
- `@mean` and `@variance` must be strictly positive numeric scalars **only if** `family = "gamma"`.
- `@tAhead` must be a strictly positive numeric scalar.
}

\examples{
# Create an `iAR` object
o=iAR::utilities()
o<-gentime(o, n=200, distribution = "expmixture", lambda1 = 130, lambda2 = 6.5,p1 = 0.15, p2 = 0.85)
times=o@times
my_iAR <- iAR(family = "norm", times = times, coef = 0.9,hessian=TRUE)

my_iAR@family
my_iAR@coef

}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
