% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_clonality_annotate.R
\name{annotate_clonality}
\alias{annotate_clonality}
\alias{annotate_clonality_rank}
\alias{annotate_clonality_prop}
\title{Annotate clonality - per-receptor labels for overabundance}
\usage{
annotate_clonality_rank(
  idata,
  bins = c(10, 30, 100, 300, 1000, 10000, 1e+05),
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

annotate_clonality_prop(
  idata,
  bins = c(Hyperexpanded = 0.01, Large = 0.001, Medium = 1e-04, Small = 1e-05, Rare =
    1e-06),
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)
}
\arguments{
\item{idata}{An \link[immundata:ImmunData]{immundata::ImmunData} object.}

\item{bins}{A \strong{named} numeric vector of thresholds (e.g.,
\code{c(Hyperexpanded = 1e-2, Large = 1e-3, ...)}). Names become bin labels and
must be non-empty. Internally sorted in descending order.}

\item{autojoin}{Logical. If TRUE, join repertoire metadata by the schema repertoire id.
Change the default behaviour by calling \code{options(immunarch.autojoin = FALSE)}.}

\item{format}{String. One of \code{"long"} ("long" tibble with \code{imd_repertoire_id}, facet
columns, and \code{value}; useful for visualizations) or \code{"wide"} (wide/unmelted table of features,
with each row corresponding to a specific repertoire / pair of repertoires; useful for Machine Learning).}
}
\value{
An \link[immundata:ImmunData]{immundata::ImmunData} whose \verb{$annotations} gains:
\itemize{
\item \code{clonal_rank_bin} - integer-like label with the applied rank threshold
(outside all thresholds -> \code{NA}).
}

An \link[immundata:ImmunData]{immundata::ImmunData} whose \verb{$annotations} gains:
\itemize{
\item \code{clonal_prop_bin} - label from \code{names(bins)} or \code{"Ultra-rare"}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A small family of helpers that \strong{add clonality labels to each receptor} in
an \link[immundata:ImmunData]{immundata::ImmunData} object.
\subsection{Available functions}{
\itemize{
\item \code{annotate_clonality_rank()} - label by \strong{rank bins} within each repertoire.
\item \code{annotate_clonality_prop()} - label by \strong{proportion bins} (named thresholds).
}
}

\code{annotate_clonality_rank()} - for each repertoire, receptors are ordered by
within-repertoire abundance (proportion) and assigned a \strong{rank bin} label.

\code{annotate_clonality_prop()} - label each receptor by \strong{proportion bin}
using named thresholds (matched in descending order; else \code{"Ultra-rare"}).
}
\examples{
\dontrun{
idata <- get_test_idata() |> agg_repertoires("Therapy")
idata_rank <- annotate_clonality_rank(idata)
idata_prop <- annotate_clonality_prop(idata)
}

}
\seealso{
\itemize{
\item Per-repertoire summaries: \link{airr_clonality}
\item Data container: \link[immundata:ImmunData]{immundata::ImmunData}
}
}
\concept{Clonality}
