% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_inset.R
\name{with_inset}
\alias{with_inset}
\title{Compose a main plot with inset(s)}
\usage{
with_inset(
  plot = NULL,
  .cfg = last_insetcfg(),
  .as_is = FALSE,
  .return_details = FALSE
)
}
\arguments{
\item{plot}{Optional. Either:
\itemize{
\item A single ggplot object to use as the base plot for all subplots (unless a spec has its own plot)
\item A list of ggplot objects matching the length of \code{.cfg$specs}, where each element
corresponds to a subplot in the configuration.
\item NULL if all specs have their own plot defined (plot is fully optional in this case)
}
NOTE: you SHOULD NOT pass \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} into this plot manually. The coordinate system is handled internally.
Default NULL.}

\item{.cfg}{An inset configuration (class "insetcfg") created by
\code{\link[=config_insetmap]{config_insetmap()}}. Defaults to \code{\link[=last_insetcfg]{last_insetcfg()}}.}

\item{.as_is}{Logical. If TRUE, return \code{plot} as-is without creating insets.
Useful when debugging or code reuse outside the inset workflow. Default FALSE.}

\item{.return_details}{Logical. If FALSE (default), returns a combined plot
with the main plot and inset layers. If TRUE,
returns a list. See 'Value' section for details.}
}
\value{
If \code{.return_details = FALSE}, a ggplot object containing the main plot plus inset layers. If TRUE, a list with elements:
\item{full}{The combined plot}
\item{subplots}{Individual ggplot objects for each subplot}
\item{subplot_layouts}{A \code{list} of layout information (\code{x}, \code{y}, \code{width}, \code{height}) for each inset}
\item{main_ratio}{Width-to-height ratio of the main plot's data extent}
}
\description{
Build a combined plot using an inset configuration created by \code{\link[=config_insetmap]{config_insetmap()}}.
For each plot specification in the configuration, the function either uses the
provided \code{spec$plot} or the supplied \code{plot} parameter and adds spatial coordinates
via \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} with the given bounding box. Non-main subplots receive
a border from \code{\link[=map_border]{map_border()}}. Insets are composed using \code{\link[patchwork:inset_element]{patchwork::inset_element()}}.
}
\examples{
library(sf)
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

config_insetmap(
    bbox = st_bbox(nc),
    specs = list(
        inset_spec(main = TRUE),
        inset_spec(
            xmin = -82, xmax = -80.5, ymin = 35.5, ymax = 36,
            loc = "left bottom", scale_factor = 2
        )
    )
)

# Supply base plot for all subplots
base <- ggplot(nc, aes(fill = AREA)) +
    geom_sf() +
    scale_fill_viridis_c() +
    guides(fill = "none") +
    theme_void()
with_inset(base)

# Or supply custom plots in each inset_spec, then call with_inset() without plot
config_insetmap(
    bbox = st_bbox(nc),
    specs = list(
        inset_spec(main = TRUE, plot = base),
        inset_spec(
            xmin = -82, xmax = -80.5, ymin = 35.5, ymax = 36,
            loc = "left bottom", scale_factor = 2,
            plot = base # Each spec has its own plot
        )
    )
)
with_inset() # plot parameter is optional now

}
\seealso{
\code{\link[=config_insetmap]{config_insetmap()}}
}
