% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafft.merge.R
\name{mafft.merge}
\alias{mafft.merge}
\title{Profile Alignment with MAFFT}
\usage{
mafft.merge(subMSA, method = "auto", gt, thread = -1, exec, quiet = TRUE)
}
\arguments{
\item{subMSA}{A list of objects of class \code{"\link[ape]{DNAbin}"} or
\code{"\link[ape]{AAbin}"}.}

\item{method}{A character string giving the alignment method. Available
accuracy-oriented methods for less than 200 sequences are
\code{"localpair"}, \code{"globalpair"}, and \code{"genafpair"};
\code{"retree 1"} and \code{"retree 2"} are for speed-oriented alignment.
The default is \code{"auto"}, which lets MAFFT choose an appropriate
alignment method.}

\item{gt}{An object of class \code{\link[ape:read.tree]{phylo}} that is to be used as a
guide tree during alignment.}

\item{thread}{Integer giving the number of physical cores MAFFT should use;
with \code{thread = -1} the number of cores is determined automatically.}

\item{exec}{A character string giving the path to the MAFFT executable
including its name, e.g. something like \code{/user/local/bin/mafft} under
UNIX-alikes.}

\item{quiet}{Logical, if set to \code{TRUE}, mafft progress is printed out on
the screen.}
}
\value{
An object of class \code{"\link[ape]{DNAbin}"} or \code{"\link[ape]{AAbin}"}.
}
\description{
Merge two or more DNA or amino acid sequence alignments by
  profile alignment with MAFFT.
}
