% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pis.R
\name{pis}
\alias{pis}
\title{Number of Potentially-Informative Sites}
\usage{
pis(x, what = "fraction", use.ambiguities = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link[ape]{DNAbin}}.}

\item{what}{Either of \code{"absolute"}, \code{"fraction"}, or
\code{"index"}, which will return the absolute number, the relative number
or the indices of the potentially-informative sites.}

\item{use.ambiguities}{\emph{Not yet available}.}
}
\value{
Numeric (depending on \code{what}, the number, fraction, or indices
  of potentially-informative nucleotide sites).
}
\description{
Returns the number or positions of potentially-informative
  (parsimony-informative, phylogenetically-informative) sites in DNA sequence
  alignment.
}
\examples{
data(ips.16S)	

# number of potentially-informative sites:
pis(ips.16S, what = "abs")

# proportion of potentially-informative sites:
pis(ips.16S, what = "frac")

# indices of potentially-informative sites:
pis(ips.16S, what = "ind")
}
