% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{testConfigurations}
\alias{testConfigurations}
\title{Execute the given configurations on the testing instances specified in the
scenario}
\usage{
testConfigurations(configurations, scenario)
}
\arguments{
\item{configurations}{\code{data.frame}\cr Parameter configurations of the
target algorithm (one per row).}

\item{scenario}{\code{list()}\cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link[=defaultScenario]{defaultScenario()}} or \code{\link[=readScenario]{readScenario()}}.}
}
\value{
A list with the following elements:
\describe{
\item{\code{experiments}}{Experiments results.}
\item{\code{seeds}}{Array of the instance seeds used in the experiments.}
}
}
\description{
Execute the given configurations on the testing instances specified in the
scenario
}
\details{
A test instance set must be provided through \code{scenario[["testInstances"]]}.
}
\seealso{
\code{\link[=testing_fromlog]{testing_fromlog()}}
}
\author{
Manuel López-Ibáñez
}
