% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcbnp.R
\name{bcbnp}
\alias{bcbnp}
\title{Bias Corrected Meta-Analysis and Meta-Regression with Dirichlet Process Mixture of normal distributions}
\usage{
bcbnp(
  data,
  formula = ~1,
  mean.mu.theta = 0,
  sd.mu.theta = 10,
  scale.sigma.between = 0.5,
  df.scale.between = 1,
  mean.mu.k = 0,
  sd.mu.k = 10,
  g.0 = 0.5,
  g.1 = 0.5,
  a.0 = 0.5,
  a.1 = 1,
  alpha.0 = 0.5,
  alpha.1 = 2,
  K = 10,
  nr.chains = 2,
  nr.iterations = 10000,
  nr.adapt = 1000,
  nr.burnin = 1000,
  nr.thin = 1,
  parallel = NULL
)
}
\arguments{
\item{data}{A data frame with at least two columns with the following names:
1) TE = treatment effect,
2) seTE = the standard error of the treatment effect.}

\item{formula}{A formula for meta-regression (e.g., ~ x1 + x2). Use ~ 1 for no covariates.}

\item{mean.mu.theta}{Prior mean of mu.theta, the default value is mean.mu.0 = 0.}

\item{sd.mu.theta}{Prior standard deviation of mu.theta, the default value is 10^-6.}

\item{scale.sigma.between}{Prior for tau.theta: Scale parameter for scale.gamma distribution for the precision 1/tau.theta^2 between studies.
The default value is 0.5.}

\item{df.scale.between}{Prior for tau.theta: Degrees of freedom of the scale.gamma distribution for the precision 1/tau.theta^2 between studies.
The default value is 1, which results in a Half Cauchy distribution for the standard
deviation between studies tau.theta. Larger values e.g. 30 corresponds to a Half Normal distribution.}

\item{mean.mu.k}{Prior mean for the mean mu.k bias cluster components. The default value is 0.}

\item{sd.mu.k}{Prior standard deviation for mu.k bias cluster component. The default is 10.}

\item{g.0}{Shape parameter the prior of the precision tau.k. The default value is 0.5 (tau.k~ dgamma(shape, rate))}

\item{g.1}{Rate parameter the prior of the precision tau.k. The default value is 0.5 (tau.k~ dgamma(shape, rate))}

\item{a.0}{Parameter for the prior Beta distribution for the probability of bias. Default value is a0 = 0.5.}

\item{a.1}{Parameter for the prior Beta distribution for the probability of bias. Default value is a1 = 1.}

\item{alpha.0}{Lower bound of the uniform prior for the concentration parameter for the DP,
the default value is 0.5.}

\item{alpha.1}{Upper bound of the uniform prior for the concentration parameter for the DP,
the default value depends on the sample size, see the example below. We give as
working value alpha.1 = 2}

\item{K}{Maximum number of clusters in the DPM, the default value depends on alpha.1, see the
example below. We give as working value K = 10.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, default is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discard for burn-in period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{parallel}{NULL -> jags, 'jags.parallel' -> jags.parallel execution}
}
\value{
This function returns an object of the class "bcbnp". This object contains the MCMC
output of each parameter and hyper-parameter in the model and
the data frame used for fitting the model.
}
\description{
This function performs a Bias Corrected Bayesian Nonparametric meta-analysis and meta-regression using a DPM of Normal distributions to the bias process
}
\details{
The results of the object of the class bcbnp can be extracted with R2jags or with rjags. In addition a summary, a print and a plot functions are
implemented for this type of object.
}
\examples{
\dontrun{
library(jarbes)


# Example: Stemcells

data("stemcells")
stemcells$TE = stemcells$effect.size
stemcells$seTE = stemcells$se.effect

# Beta(0.5, 1)
a.0 = 0.5
a.1 = 1

# alpha.max
N = dim(stemcells)[1]
alpha.max = 1/5 *((N-1)*a.0 - a.1)/(a.0 + a.1)

alpha.max

# K.max
K.max = 1 + 5*alpha.max
K.max = round(K.max)

K.max

set.seed(20233)

bcbnp.stemcell = bcbnp(stemcells
alpha.0 = 0.5,
alpha.1 = alpha.max,
a.0 = a.0,
a.1 = a.1,
K = K.max,
nr.chains = 4,
nr.iterations = 50000,
nr.adapt = 1000,
nr.burnin = 10000,
nr.thin = 4)


}

}
\references{
Verde, P.E., and Rosner, G.L. (2025a), A Bias-Corrected Bayesian Nonparametric Model for Combining Studies With Varying Quality in Meta-Analysis. Biometrical Journal., 67: e70034. https://doi.org/10.1002/bimj.70034

Verde, P.E, and Rosner, G.L. (2025b), jarbes: an R package for bias corrected meta-analysis models
}
