% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_patterns.R
\name{detect_cardinality}
\alias{detect_cardinality}
\title{Detect Join Relationship Type}
\usage{
detect_cardinality(x, y, by)
}
\arguments{
\item{x}{A data frame (left table).}

\item{y}{A data frame (right table).}

\item{by}{Column names to join by.}
}
\value{
Character string: "1:1", "1:m", "m:1", or "m:m".
}
\description{
Determines the actual cardinality relationship between two tables.
}
\examples{
# 1:1 relationship
x <- data.frame(id = 1:3, val = 1:3)
y <- data.frame(id = 1:3, name = c("A", "B", "C"))
detect_cardinality(x, y, "id")

# 1:m relationship
x <- data.frame(id = 1:3, val = 1:3)
y <- data.frame(id = c(1, 1, 2, 3), name = c("A1", "A2", "B", "C"))
detect_cardinality(x, y, "id")

}
\seealso{
\code{\link[=join_strict]{join_strict()}}, \code{\link[=join_spy]{join_spy()}}
}
