% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_get_confirmed.R
\name{jpinfect_get_confirmed}
\alias{jpinfect_get_confirmed}
\title{Download the confirmed case datasets from the Japan Institute for Health Security (JIHS)}
\usage{
jpinfect_get_confirmed(
  years = NULL,
  type = "sex",
  overwrite = FALSE,
  dest_dir = NULL
)
}
\arguments{
\item{years}{(numeric) A vector of years to download data for. If \code{NULL},
the most recent available year will be used. Available years range from 1999 to 2023.}

\item{type}{(character) The type of data to download. Must be either \code{"sex"}
or \code{"place"}.}

\item{overwrite}{(logical) Whether to overwrite existing files. Defaults to \code{FALSE}.}

\item{dest_dir}{Directory to save files. If NULL, uses tempdir() (files deleted when R session ends).
Specify a permanent directory to keep downloaded data.}
}
\value{
A named list mapping each requested year to its downloaded file path.
Successful years contain a character path; failed years are \code{NULL}.
}
\description{
This function downloads infectious disease data from the Japan Institute for Health Security (JIHS) for specified years and types.
}
\details{
This function validates the input parameters, including the range of years and
the type of data. It creates the destination directory if it does not already exist.
For each year, the function attempts to download the corresponding file from JIHS.
If a file already exists and \code{overwrite = FALSE}, the download is skipped.
}
\examples{
\donttest{
# Download data for 2020 and 2021
jpinfect_get_confirmed(years = c(2020, 2021), type = "sex")

# Download data for all available years
jpinfect_get_confirmed(type = "place")
}

}
