% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp01_functions.R
\name{resp01_split_fun_fct}
\alias{resp01_split_fun_fct}
\title{Split Function Factory for the Response Tables (RESP01)}
\usage{
resp01_split_fun_fct(method = c("rr", "or_logistic", "or_cmh"), conf_level)
}
\arguments{
\item{method}{(\code{string})\cr which method to use for the comparative statistics.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
A split function for use in the response table RESP01 and similar ones.
}
\description{
The main purpose here is to have a column dependent split into either comparative
statistic (relative risk or odds ratio with p-value) in the 'Overall' column,
and count proportions and corresponding confidence intervals in the other treatment
arm columns.
}
\examples{
split_fun <- resp01_split_fun_fct(
  method = "or_cmh",
  conf_level = 0.95
)
}
\seealso{
\code{\link[rtables:make_split_fun]{rtables::make_split_fun()}} describing the requirements for this kind of
post-processing function.
}
