% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwidths.R
\name{smart_colwidths_1page}
\alias{smart_colwidths_1page}
\title{Colwidths for all columns to be forced on one page.}
\usage{
smart_colwidths_1page(
  tt,
  fontspec,
  col_gap = 6L,
  rowlabel_width = inches_to_spaces(2, fontspec),
  print_width_ins = ifelse(landscape, 11, 8.5) - 2.12,
  landscape = FALSE,
  lastcol_gap = TRUE
)
}
\arguments{
\item{tt}{(\code{TableTree})\cr TableTree object to calculate column widths for}

\item{fontspec}{(\code{font_spec})\cr Font specification object}

\item{col_gap}{(\code{numeric})\cr Column gap in spaces}

\item{rowlabel_width}{(\code{numeric})\cr Width of row labels in spaces}

\item{print_width_ins}{(\code{numeric})\cr Print width in inches}

\item{landscape}{(\code{logical})\cr Whether the output is in landscape orientation}

\item{lastcol_gap}{(\code{logical})\cr Whether to include a gap after the last column}
}
\description{
Colwidths for all columns to be forced on one page.
}
\keyword{internal}
