% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_freq_combos_j.R
\name{a_freq_combos_j}
\alias{a_freq_combos_j}
\title{Analysis function count and percentage in column design controlled by combosdf}
\usage{
a_freq_combos_j(
  df,
  labelstr = NULL,
  .var = NA,
  val = NULL,
  combosdf = NULL,
  do_not_filter = NULL,
  filter_var = NULL,
  flag_var = NULL,
  .df_row,
  .spl_context,
  .N_col,
  id = "USUBJID",
  denom = c("N_col", "n_df", "n_altdf", "n_rowdf", "n_parentdf"),
  label = NULL,
  label_fstr = NULL,
  label_map = NULL,
  .alt_df_full = NULL,
  denom_by = NULL,
  .stats = "count_unique_denom_fraction",
  .formats = NULL,
  .labels_n = NULL,
  .indent_mods = NULL,
  na_str = rep("NA", 3)
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{val}{(\code{character} or NULL)\cr
When NULL, all levels of the incoming variable (variable used in the \code{analyze} call)
will be considered.\cr
When a single \code{string}, only that current level/value of the incoming variable
will be considered.\cr
When multiple levels, only those levels/values of the incoming variable
will be considered.\cr
When no values are observed (eg zero row input df),
a row with row-label \verb{No data reported} will be included in the table.}

\item{combosdf}{The df which provides the mapping of column facets to produce cumulative counts for .N_col.\cr
In the cell facet, these cumulative records must then be removed from the numerator,
which can be done via the filter_var parameter
to avoid unwanted counting of events.}

\item{do_not_filter}{A vector of facets (i.e., column headers), identifying headers for which
no filtering of records should occur.
That is, the numerator should contain cumulative counts.  Generally, this will be used for a
"Total" column, or something similar.}

\item{filter_var}{The variable which identifies the records to count in the numerator for any given column.
Generally, this will contain text matching the column header for the column associated with a given record.}

\item{flag_var}{Variable which identifies the occurrence (or first occurrence) of an event.
The flag variable is expected to have a value of "Y" identifying that the event should be counted, or NA otherwise.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{.N_col}{(\code{integer})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{id}{(\code{string})\cr subject variable name.}

\item{denom}{(\code{string})\cr
One of \cr
\itemize{
\item \strong{N_col} Column count, \cr
\item \strong{n_df} Number of patients (based upon the main input dataframe \code{df}),\cr
\item \strong{n_altdf} Number of patients from the secondary dataframe (\code{.alt_df_full}),\cr
Note that argument \code{denom_by} will perform a row-split on the \code{.alt_df_full} dataframe.\cr
It is a requirement that variables specified in \code{denom_by} are part of the row split specifications. \cr
\item \strong{n_rowdf} Number of patients from the current row-level dataframe
(\code{.row_df} from the rtables splitting machinery).\cr
\item \strong{n_parentdf} Number of patients from a higher row-level split than the current split.\cr
This higher row-level split is specified in the argument \code{denom_by}.\cr
}}

\item{label}{(\code{string})\cr
When \code{val} has length 1,
the row label to be shown on the output can be specified using this argument.\cr
When \code{val} is a \verb{character vector}, the \code{label_map} argument can be specified
to control the row-labels.}

\item{label_fstr}{(\code{string})\cr
a sprintf style format string.
It can contain up to one \code{"\%s"}, which takes the current split value and
generates the row/column label.\cr
It will be combined with the \code{labelstr} argument,
when utilizing this function as
a \code{cfun} in a \code{summarize_row_groups} call.\cr
It is recommended not to utilize this argument for other purposes.
The label argument could be used instead (if \code{val} is a single string)\cr}

\item{label_map}{(\code{tibble})\cr
A mapping tibble to translate levels from the incoming variable into
a different row label to be presented on the table.\cr}

\item{.alt_df_full}{(\code{dataframe})\cr Denominator dataset
for fraction and relative risk calculations.\cr
this argument gets populated by the rtables
split machinery (see \link[rtables:additional_fun_params]{rtables::additional_fun_params}).}

\item{denom_by}{(\code{character})\cr Variables from row-split
to be used in the denominator derivation.\cr
This controls both \code{denom = "n_parentdf"} and \code{denom = "n_altdf"}.\cr
When \code{denom = "n_altdf"}, the denominator is derived from \code{.alt_df_full}
in combination with \code{denom_by} argument}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named 'character' or 'list')\cr
formats for the statistics.}

\item{.labels_n}{(named \code{character})\cr
String to control row labels for the 'n'-statistics.\cr
Only useful when more than one 'n'-statistic is requested (rare situations only).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}
}
\value{
list of requested statistics with formatted \code{rtables::CellValue()}.\cr
}
\description{
Analysis function count and percentage in column design controlled by combosdf
}
\examples{
library(dplyr)
ADSL <- ex_adsl |> select(USUBJID, ARM, EOSSTT, EOSDT, EOSDY, TRTSDTM)

cutoffd <- as.Date("2023-09-24")

ADSL <- ADSL |>
  mutate(
    TRTDURY = case_when(
      !is.na(EOSDY) ~ EOSDY,
      TRUE ~ as.integer(cutoffd - as.Date(TRTSDTM) + 1)
    )
  ) |>
  mutate(ACAT1 = case_when(
    TRTDURY < 183 ~ "0-6 Months",
    TRTDURY < 366 ~ "6-12 Months",
    TRUE ~ "+12 Months"
  )) |>
  mutate(ACAT1 = factor(ACAT1, levels = c("0-6 Months", "6-12 Months", "+12 Months")))


ADAE <- ex_adae |> select(USUBJID, ARM, AEBODSYS, AEDECOD, ASTDY)

ADAE <- ADAE |>
  mutate(TRTEMFL = "Y") |>
  mutate(ACAT1 = case_when(
    ASTDY < 183 ~ "0-6 Months",
    ASTDY < 366 ~ "6-12 Months",
    TRUE ~ "+12 Months"
  )) |>
  mutate(ACAT1 = factor(ACAT1, levels = c("0-6 Months", "6-12 Months", "+12 Months")))

combodf <- tribble(
  ~valname, ~label, ~levelcombo, ~exargs,
  "Tot", "Total", c("0-6 Months", "6-12 Months", "+12 Months"), list(),
  "A_0-6 Months", "0-6 Months", c("0-6 Months", "6-12 Months", "+12 Months"), list(),
  "B_6-12 Months", "6-12 Months", c("6-12 Months", "+12 Months"), list(),
  "C_+12 Months", "+12 Months", c("+12 Months"), list()
)


lyt <- basic_table(show_colcounts = TRUE) |>
  split_cols_by("ARM") |>
  split_cols_by("ACAT1",
    split_fun = add_combo_levels(combosdf = combodf, trim = FALSE, keep_levels = combodf$valname)
  ) |>
  analyze("TRTEMFL",
    show_labels = "hidden",
    afun = a_freq_combos_j,
    extra_args = list(
      val = "Y",
      label = "Subjects with >= 1 AE",
      combosdf = combodf,
      filter_var = "ACAT1",
      do_not_filter = "Tot"
    )
  )


result <- build_table(lyt, df = ADAE, alt_counts_df = ADSL)

result
}
