% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmbasisfringe.R
\name{kmbasisfringe}
\alias{kmbasisfringe}
\alias{kmbasisinnerfringe}
\alias{kmbasisouterfringe}
\title{Compute the fringe of a state within a knowledge structure using its basis}
\usage{
kmbasisfringe(state, basis)

kmbasisinnerfringe(state, basis)

kmbasisouterfringe(state, basis)
}
\arguments{
\item{state}{Binary vector representing a knowledge state}

\item{basis}{\code{kmbasis} object}
}
\value{
Binary vector representing the fringe
}
\description{
\code{kmbasisfringe} computes the fringe of a state
within a knowledge structure, i.e. the set of items by which
the state differs from its neighbours.
}
\examples{
kmbasisfringe(c(1,0,0,0), xpl$basis)

}
\references{
Hockemeyer C (1997). Using the Basis of a Knowledge Space for
Determining the Fringe of a Knowledge State.
\emph{Journal of Mathematical Psychology, 41,} 275–279.
}
\seealso{
Other Fringes & learning paths: 
\code{\link{kmbasisneighbourhood}()},
\code{\link{kmfringe}()},
\code{\link{kmgradations}()},
\code{\link{kmlearningpaths}()},
\code{\link{kmneighbourhood}()},
\code{\link{kmnneighbourhood}()}
}
\concept{Fringes & learning paths}
