% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{conafchile_pts}
\alias{conafchile_pts}
\title{Georeferenced Forest Fires in Chile (2016–2017 Season)}
\format{
A data frame with 5,234 observations and 30 variables:
\describe{
  \item{X}{Index of the fire record (integer)}
  \item{temporada}{Fire season (character, e.g., "2016-2017")}
  \item{codreg}{Region code (integer)}
  \item{codprov}{Province code (integer)}
  \item{codcom}{Commune code (integer)}
  \item{ambito}{Institutional scope (character, e.g., "Conaf")}
  \item{numero}{Fire identification number (numeric)}
  \item{nombre_inc}{Name of the fire incident (character)}
  \item{utm_este}{UTM Easting coordinate (numeric)}
  \item{utm_norte}{UTM Northing coordinate (numeric)}
  \item{inicio_c}{Location of ignition (character)}
  \item{combus_i}{Initial fuel type (character)}
  \item{causa_gene}{General cause code (numeric)}
  \item{causa_espe}{Specific cause code (character)}
  \item{pino_0010}{Surface with pine (0–10 years old) affected (numeric)}
  \item{pino_11_17}{Surface with pine (11–17 years old) affected (numeric)}
  \item{pino_18}{Surface with pine (18+ years old) affected (numeric)}
  \item{eucalipto}{Surface with eucalyptus affected (numeric)}
  \item{otras_plan}{Surface with other plantations affected (numeric)}
  \item{total_plan}{Total surface of plantations affected (numeric)}
  \item{arbolado}{Surface of woodland affected (numeric)}
  \item{matorral}{Surface of shrubland affected (numeric)}
  \item{pastizal}{Surface of grassland affected (numeric)}
  \item{total_veg}{Total surface of vegetation affected (numeric)}
  \item{agricola}{Surface of agricultural land affected (numeric)}
  \item{desechos}{Surface of waste material affected (numeric)}
  \item{total_otra}{Total surface of other land use affected (numeric)}
  \item{sup_t_a}{Total affected surface area (numeric)}
  \item{long}{Longitude or projected coordinate (numeric)}
  \item{lat}{Latitude or projected coordinate (numeric)}
}
}
\source{
Data taken from Kaggle:
\url{https://www.kaggle.com/datasets/sandorabad/georeferenced-forestfires-2017-chile}
}
\usage{
data(conafchile_pts)
}
\description{
This dataset, `conafchile_pts`, is a data frame containing georeferenced forest fire records and
associated characteristics between July 1, 2016, and June 30, 2017. The dataset includes detailed
information such as location, administrative codes, fire causes, vegetation affected, and surface
area impacted. The data were compiled by CONAF and correspond to forest fires recorded in Chile.
}
\details{
The dataset name has been kept as `conafchile_pts` to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
lightsf package and assists users in identifying its specific characteristics.
The suffix `pts` indicates that the dataset contains georeferenced point data.
The original content has not been modified in any way.
}
