% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce_linter.R
\name{coalesce_linter}
\alias{coalesce_linter}
\title{Encourage usage of the null coalescing operator \verb{\%||\%}}
\usage{
coalesce_linter()
}
\description{
The \code{x \%||\% y} is equivalent to
\code{if (is.null(x)) y else x}, but more expressive.
It is exported by R since 4.4.0, and equivalents
have been available in other tidyverse packages
for much longer, e.g. 2008 for ggplot2.
}
\examples{
# will produce lints
lint(
  text = "if (is.null(x)) y else x",
  linters = coalesce_linter()
)

lint(
  text = "if (!is.null(x)) x else y",
  linters = coalesce_linter()
)

lint(
  text = "if (is.null(x[1])) x[2] else x[1]",
  linters = coalesce_linter()
)

# okay
lint(
  text = "x \%||\% y",
  linters = coalesce_linter()
)

lint(
  text = "x \%||\% y",
  linters = coalesce_linter()
)

lint(
  text = "x[1] \%||\% x[2]",
  linters = coalesce_linter()
)


}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
