% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_client.R
\name{diagnose_llm_connection}
\alias{diagnose_llm_connection}
\title{Comprehensive LLM connection diagnostics}
\usage{
diagnose_llm_connection(base_url, api_key, model, test_tidyprompt = TRUE)
}
\arguments{
\item{base_url}{The API base URL}

\item{api_key}{The API key}

\item{model}{The model name}

\item{test_tidyprompt}{Whether to test tidyprompt compatibility}
}
\value{
A list (invisible) containing test results with elements:
\itemize{
\item \code{connectivity}: Logical indicating if basic network connectivity passed
\item \code{endpoint}: Logical indicating if API endpoint is accessible
\item \code{auth}: Logical indicating if authentication and model test passed
\item \code{tidyprompt}: Logical indicating tidyprompt compatibility (if tested)
}
}
\description{
This function provides detailed diagnostics for LLM connection issues,
helping identify problems at different levels of the stack.
}
