% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpme_DoBootPartition.R
\name{lpmec}
\alias{lpmec}
\title{lpmec}
\usage{
lpmec(
  Y,
  observables,
  observables_groupings = colnames(observables),
  orientation_signs = NULL,
  make_observables_groupings = FALSE,
  n_boot = 32L,
  n_partition = 10L,
  boot_basis = 1:length(Y),
  return_intermediaries = TRUE,
  ordinal = FALSE,
  estimation_method = "em",
  latent_estimation_fn = NULL,
  mcmc_control = list(backend = "pscl", n_samples_warmup = 500L, n_samples_mcmc = 1000L,
    batch_size = 512L, chain_method = "parallel", subsample_method = "full",
    anchor_parameter_id = NULL, n_thin_by = 1L, n_chains = 2L),
  conda_env = "lpmec",
  conda_env_required = FALSE
)
}
\arguments{
\item{Y}{A vector of observed outcome variables}

\item{observables}{A matrix of observable indicators used to estimate the latent variable}

\item{observables_groupings}{A vector specifying groupings for the observable indicators. Default is column names of observables.}

\item{orientation_signs}{(optional) A numeric vector of length equal to the number of columns in `observables`, containing 1 or -1 to indicate the desired orientation of each column. If provided, each column of `observables` will be oriented by this sign before analysis. Default is NULL (no orientation applied).}

\item{make_observables_groupings}{Logical. If TRUE, creates dummy variables for each level of the observable indicators. Default is FALSE.}

\item{n_boot}{Integer. Number of bootstrap iterations. Default is 32.}

\item{n_partition}{Integer. Number of partitions for each bootstrap iteration. Default is 10.}

\item{boot_basis}{Vector of indices or grouping variable for stratified bootstrap. Default is 1:length(Y).}

\item{return_intermediaries}{Logical. If TRUE, returns intermediate results. Default is TRUE.}

\item{ordinal}{Logical indicating whether the observable indicators are ordinal (TRUE) or binary (FALSE).}

\item{estimation_method}{Character specifying the estimation approach. Options include:
\itemize{
\item "em" (default): Uses expectation-maximization via \code{emIRT} package. Supports both binary (via \code{emIRT::binIRT}) and ordinal (via \code{emIRT::ordIRT}) indicators.
\item "pca": First principal component of observables.
\item "averaging": Uses feature averaging.
\item "mcmc": Markov Chain Monte Carlo estimation using either \code{pscl::ideal} (R backend) or \code{numpyro} (Python backend)
\item "mcmc_joint": Joint Bayesian model that simultaneously estimates latent variables and outcome relationship using \code{numpyro}
\item "mcmc_overimputation": Two-stage MCMC approach with measurement error correction via over-imputation
\item "custom": In this case, latent estimation performed using \code{latent_estimation_fn}.
}}

\item{latent_estimation_fn}{Custom function for estimating latent trait from \code{observables} if \code{estimation_method="custom"} (optional). The function should accept a matrix of observables (rows are observations) and return a numeric vector of length equal to the number of observations.}

\item{mcmc_control}{A list indicating parameter specifications if MCMC used.
\describe{
  \item{\code{backend}}{Character string indicating the MCMC engine to use.
    Valid options are \code{"pscl"} (default, uses the R-based \code{pscl::ideal} function)
    or \code{"numpyro"} (uses the Python numpyro package via reticulate).}
  \item{\code{n_samples_warmup}}{Integer specifying the number of warm-up (burn-in)
    iterations before samples are collected. Default is \code{500}.}
  \item{\code{n_samples_mcmc}}{Integer specifying the number of post-warmup MCMC
    iterations to retain. Default is \code{1000}.}
  \item{\code{chain_method}}{Character string passed to numpyro specifying how to run
    multiple chains. Options: \code{"parallel"} (default), \code{"sequential"},
    or \code{"vectorized"}.}
  \item{\code{n_thin_by}}{Integer indicating the thinning factor for MCMC samples.
    Default is \code{1}.}
  \item{\code{n_chains}}{Integer specifying the number of parallel MCMC chains to run.
    Default is \code{2}.}
}}

\item{conda_env}{A character string specifying the name of the conda environment to use
via \code{reticulate}. Default is \code{"lpmec"}.}

\item{conda_env_required}{A logical indicating whether the specified conda environment
must be strictly used. If \code{TRUE}, an error is thrown if the environment is not found.
Default is \code{FALSE}.}
}
\value{
A list containing various estimates and statistics (in snake_case):
\itemize{
  \item \code{ols_coef}: Coefficient from naive OLS regression.
  \item \code{ols_se}: Standard error of naive OLS coefficient.
  \item \code{ols_tstat}: T-statistic of naive OLS coefficient.
  \item \code{iv_coef}: Coefficient from instrumental variable (IV) regression.
  \item \code{iv_se}: Standard error of IV regression coefficient.
  \item \code{iv_tstat}: T-statistic of IV regression coefficient.
  \item \code{corrected_iv_coef}: IV regression coefficient corrected for measurement error.
  \item \code{corrected_iv_se}: Standard error of the corrected IV coefficient (currently \code{NA}).
  \item \code{corrected_iv_tstat}: T-statistic of the corrected IV coefficient.
  \item \code{var_est}: Estimated variance of the measurement error (split-half variance).
  \item \code{corrected_ols_coef}: OLS coefficient corrected for measurement error.
  \item \code{corrected_ols_se}: Standard error of the corrected OLS coefficient (currently \code{NA}).
  \item \code{corrected_ols_tstat}: T-statistic of the corrected OLS coefficient (currently \code{NA}).
  \item \code{corrected_ols_coef_alt}: Alternative corrected OLS coefficient (if applicable).
  \item \code{corrected_ols_se_alt}: Standard error for the alternative corrected OLS coefficient (if applicable).
  \item \code{corrected_ols_tstat_alt}: T-statistic for the alternative corrected OLS coefficient (if applicable).
  \item \code{bayesian_ols_coef_outer_normed}: Posterior mean of the OLS coefficient under MCMC, 
    after normalizing by the overall sample standard deviation.
  \item \code{bayesian_ols_se_outer_normed}: Posterior standard error corresponding to \code{bayesian_ols_coef_outer_normed}.
  \item \code{bayesian_ols_tstat_outer_normed}: T-statistic for \code{bayesian_ols_coef_outer_normed}.
  \item \code{bayesian_ols_coef_inner_normed}: Posterior mean of the OLS coefficient under MCMC, 
    after normalizing each posterior draw individually.
  \item \code{bayesian_ols_se_inner_normed}: Posterior standard error corresponding to \code{bayesian_ols_coef_inner_normed}.
  \item \code{bayesian_ols_tstat_inner_normed}: T-statistic for \code{bayesian_ols_coef_inner_normed}.
  \item \code{m_stage_1_erv}: Extreme robustness value (ERV) for the first-stage regression 
    (\code{x_est2} on \code{x_est1}), if computed.
  \item \code{m_reduced_erv}: ERV for the reduced model (\code{Y} on \code{x_est1}), if computed.
  \item \code{x_est1}: First set of latent variable estimates.
  \item \code{x_est2}: Second set of latent variable estimates.
}
}
\description{
Implements bootstrapped analysis for latent variable models with measurement error correction
}
\details{
This function implements a bootstrapped latent variable analysis with measurement error correction.
It performs multiple bootstrap iterations, each with multiple partitions. For each partition,
it calls the \code{lpmec_onerun} function to estimate latent variables and apply various correction methods.
The results are then aggregated across partitions and bootstrap iterations to produce final estimates
and bootstrap standard errors.
}
\examples{
\donttest{
# Generate some example data
set.seed(123)
Y <- rnorm(1000)
observables <- as.data.frame(matrix(sample(c(0,1), 1000*10, replace = TRUE), ncol = 10))

# Run the bootstrapped analysis
results <- lpmec(Y = Y,
                 observables = observables,
                 n_boot = 10,    # small values for illustration only
                 n_partition = 5 # small for size
                 )

# View the corrected IV coefficient and its standard error
print(results)
}

}
\references{
Jerzak, C. T. and Jessee, S. A. (2025). Attenuation Bias with Latent Predictors.
arXiv:2507.22218 [stat.AP]. \url{https://arxiv.org/abs/2507.22218}
}
