% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordered_suggest.R
\name{ordered_suggest}
\alias{ordered_suggest}
\title{Heuristic procedure for identifying ordered categorical variables}
\usage{
ordered_suggest(data, max_categories = 7)
}
\arguments{
\item{data}{Raw data matrix or data frame containing the variables to be
included in the network. May include missing values.}

\item{max_categories}{Maximum number of categories a variable may have to be
treated as ordered (default: 7).}
}
\value{
A logical vector of length \code{ncol(data)} indicating, for each variable, whether
it is recommended to be treated as ordered (\code{TRUE}) or continuous
(\code{FALSE}). Additionally, a message is printed to the console summarizing the
recommendation in terms of which correlation methods to use.
}
\description{
Suggests which variables in a data set may be treated as ordered categorical
based on their number of unique categories and the amount of available
information for estimating the network structure. This function provides a
preliminary, non-binding recommendation and should be interpreted as a
beta-level heuristic.
}
\details{
While polychoric correlations are generally more appropriate for ordered categorical
data \insertCite{@foldness.2022}{mantar}, they may encounter estimation problems if
the number of available observations is small relative to the number of estimated
parameters \insertCite{@see e.g., @johal.2023}{mantar}. Our preliminary simulations
suggest that in such cases Pearson correlations may introduce less bias, an effect
that becomes even more pronounced when data are missing.

This helper function provides a recommendation on which variables to treat as
ordered. In general, variables with more than \code{max_categories} categories are
recommended to be treated as continuous, whereas for variables with fewer categories
the procedure evaluates whether the amount of available information is too limited
to justify polychoric estimation, in which case Pearson correlations are recommended
instead. This procedure is only a helper, is still under early development, and may
be refined in future versions.
}
\examples{
# Suggest ordered variables in a data set with mixed variable types
# (400 observations for 8 variables)
ordered_suggest(data = mantar_dummy_full_mix, max_categories = 7)

}
\references{
\insertAllCited{}
}
