% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_emperors.R
\docType{data}
\name{emperors}
\alias{emperors}
\title{Emperors datacube documentation}
\format{
\describe{
\item{Wikipedia: }{A dataset with 68 observations and the
following 15 variables:
ID, Begin, End, FullName, Birth, Death,
CityBirth, ProvinceBirth, Rise, Cause,
Killer, Dynasty, Era, Notes, Verif.}
\item{UNRV: }{A dataset with 99 observations and the
following 7 variables: ID, Begin, End,
Birth, Death, FullName, Dynasty.}
\item{Britannica: }{A dataset with 87 observations and the
following 3 variables: ID, Begin, End.}
}
}
\source{
\itemize{
\item Wikipedia, 'List_of_Roman_emperors',  https://en.wikipedia.org/wiki/List_of_Roman_emperors, Accessed on 2021-07-22.
\item United Nations of Roma Victrix, 'Roman Emperor list', https://www.unrv.com/government/emperor.php, Accessed on 2021-07-22.
\item Britannica, 'List of Roman emperors', https://www.britannica.com/topic/list-of-Roman-emperors-2043294, Accessed on 2021-07-22.
}
}
\usage{
emperors
}
\description{
The \code{emperors} datacube is a list containing 3 datasets: Wikipedia, UNRV, and Britannica
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> $Wikipedia
#> --------------------------------------------------------
#> |  Variable   |  Class  |  Obs  |  Missing  |  Miss \%  |
#> --------------------------------------------------------
#> |ID           |character|     69|          0|         0|
#> |Begin        |mdate    |     69|          0|         0|
#> |End          |mdate    |     69|          0|         0|
#> |FullName     |character|     68|          1|      1.45|
#> |Birth        |mdate    |     63|          6|       8.7|
#> |Death        |mdate    |     68|          1|      1.45|
#> |CityBirth    |character|     51|         18|     26.09|
#> |ProvinceBirth|character|     68|          1|      1.45|
#> |Rise         |character|     68|          1|      1.45|
#> |Cause        |character|     68|          1|      1.45|
#> |Killer       |character|     68|          1|      1.45|
#> |Dynasty      |character|     68|          1|      1.45|
#> |Era          |character|     68|          1|      1.45|
#> |Notes        |character|     46|         23|     33.33|
#> --------------------------------------------------------
#> 
#> 
#> $UNRV
#> -------------------------------------------------------
#> |  Variable  |  Class  |  Obs  |  Missing  |  Miss \%  |
#> -------------------------------------------------------
#> |ID          |character|     98|          0|         0|
#> |Begin       |mdate    |     98|          0|         0|
#> |End         |mdate    |     98|          0|         0|
#> |Birth       |mdate    |     74|         24|     24.49|
#> |Death       |mdate    |     98|          0|         0|
#> |FullName    |character|     93|          5|       5.1|
#> |Dynasty     |character|     61|         37|     37.76|
#> -------------------------------------------------------
#> 
#> 
#> $Britannica
#> -------------------------------------------------------
#> |  Variable  |  Class  |  Obs  |  Missing  |  Miss \%  |
#> -------------------------------------------------------
#> |ID          |character|     87|          0|         0|
#> |Begin       |mdate    |     87|          0|         0|
#> |End         |mdate    |     87|          0|         0|
#> -------------------------------------------------------
}\if{html}{\out{</div>}}
}
\section{URL}{

\itemize{
\item Wikipedia: \url{https://en.wikipedia.org/wiki/List_of_Roman_emperors}
\item UNRV: \url{https://www.unrv.com/government/emperor.php}
\item Britannica: \url{https://www.britannica.com/place/list-of-Roman-emperors-2043294}
}
}

\section{Mapping}{

\itemize{
\item wikipedia:
Variable Mapping
}\tabular{cc}{
   \emph{from} \tab \emph{to} \cr
   name \tab ID \cr
   reign.start \tab Begin \cr
   reign.end \tab End \cr
   name.full \tab FullName \cr
   birth \tab Birth \cr
   death \tab Death \cr
   birth.cty \tab CityBirth \cr
   birth.prv \tab ProvinceBirth \cr
   rise \tab Rise \cr
   cause \tab Cause \cr
   killer \tab Killer \cr
   dynasty \tab Dynasty \cr
   era \tab Era \cr
   notes \tab Notes \cr
   verif.who \tab Verif \cr
}

\itemize{
\item UNRV:
Variable Mapping
}\tabular{cc}{
   \emph{from} \tab \emph{to} \cr
   'Common Name' \tab ID \cr
   Beg \tab Begin \cr
   'Full Name/Imperial Name' \tab FullName \cr
   'Dynasty/Class/Notes' \tab Dynasty \cr
}

\itemize{
\item britannica:
Variable Mapping
}\tabular{cc}{
   \emph{from} \tab \emph{to} \cr
   Name \tab ID \cr
   reign_start \tab Begin \cr
   reign_end \tab End \cr
}
}

\keyword{datasets}
