% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\name{number_format}
\alias{number_format}
\title{Create a number formatting expression}
\usage{
number_format(
  column,
  locale = "en-US",
  style = "decimal",
  currency = NULL,
  unit = NULL,
  minimum_fraction_digits = NULL,
  maximum_fraction_digits = NULL,
  minimum_integer_digits = NULL,
  use_grouping = NULL,
  notation = NULL,
  compact_display = NULL
)
}
\arguments{
\item{column}{The name of the column containing the numeric value to format.
Can also be an expression that evaluates to a number.}

\item{locale}{A string specifying the locale to use for formatting (e.g., "en-US",
"de-DE", "fr-FR"). Defaults to "en-US".}

\item{style}{The formatting style to use. Options include:
\itemize{
\item "decimal" (default): Plain number formatting
\item "currency": Currency formatting (requires \code{currency} parameter)
\item "percent": Percentage formatting (multiplies by 100 and adds \%)
\item "unit": Unit formatting (requires \code{unit} parameter)
}}

\item{currency}{For style = "currency", the ISO 4217 currency code (e.g., "USD", "EUR", "GBP").}

\item{unit}{For style = "unit", the unit to use (e.g., "kilometer", "mile", "liter").}

\item{minimum_fraction_digits}{The minimum number of fraction digits to display.}

\item{maximum_fraction_digits}{The maximum number of fraction digits to display.}

\item{minimum_integer_digits}{The minimum number of integer digits to display.}

\item{use_grouping}{Whether to use grouping separators (e.g., thousands separators).
Defaults to TRUE.}

\item{notation}{The formatting notation. Options include:
\itemize{
\item "standard" (default): Regular notation
\item "scientific": Scientific notation
\item "engineering": Engineering notation
\item "compact": Compact notation (e.g., "1.2K", "3.4M")
}}

\item{compact_display}{For notation = "compact", whether to use "short" (default)
or "long" form.}
}
\value{
A list representing the number-format expression.
}
\description{
This function creates a number formatting expression that formats numeric values
according to locale-specific conventions. It can be used in tooltips, popups,
and text fields for symbol layers.
}
\examples{
# Basic number formatting with thousands separators
number_format("population")

# Currency formatting
number_format("income", style = "currency", currency = "USD")

# Percentage with 1 decimal place
number_format("rate", style = "percent", maximum_fraction_digits = 1)

# Compact notation for large numbers
number_format("population", notation = "compact")

# Using within a tooltip
concat("Population: ", number_format("population", notation = "compact"))

# Using with get_column()
number_format(get_column("value"), style = "currency", currency = "EUR")
}
