% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{points_from_sf}
\alias{points_from_sf}
\title{Extract Point Coordinates from sf Objects}
\usage{
points_from_sf(sf_obj, id_col = NULL)
}
\arguments{
\item{sf_obj}{An \code{sf} or \code{sfc} object containing \code{POINT} geometries.}

\item{id_col}{Character. Optional column name to use as point IDs.
If \code{NULL}, IDs are generated as sequential integers.
(default = \code{NULL}).}
}
\value{
A list of lists, each containing:
\itemize{
\item \code{id}: Character identifier for the point
\item \code{x}: Numeric x-coordinate
\item \code{y}: Numeric y-coordinate
}
}
\description{
Converts \code{sf} point geometries into a list structure containing
coordinate pairs, suitable for serialization to JSON or use in
JavaScript visualizations.
}
\details{
This function prepares point geometries for client-side rendering
as circles or markers in SVG or Canvas visualizations.
}
\examples{
\dontrun{
library(sf)

# Create simple points
pts <- st_sfc(st_point(c(0, 0)), st_point(c(1, 1)))
sf_obj <- st_sf(id = c("A", "B"), geometry = pts)

# Extract coordinates
coords <- points_from_sf(sf_obj, id_col = "id")
str(coords)
}

}
\seealso{
\code{\link[=polygons_from_sf]{polygons_from_sf()}}, \code{\link[=lines_from_sf]{lines_from_sf()}}, \code{\link[=shiny_fisheye]{shiny_fisheye()}}
}
\keyword{internal}
