% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{polygons_from_sf}
\alias{polygons_from_sf}
\title{Extract Polygon Coordinates from sf Objects}
\usage{
polygons_from_sf(sf_obj, id_col = NULL)
}
\arguments{
\item{sf_obj}{An \code{sf} or \code{sfc} object containing \code{POLYGON} or
\code{MULTIPOLYGON} geometries.}

\item{id_col}{Character. Optional column name to use as polygon IDs.
If \code{NULL}, IDs are generated as \code{"poly-1"}, \code{"poly-2"}, etc.
(default = \code{NULL}).}
}
\value{
A list of lists, each containing:
\itemize{
\item \code{id}: Character identifier for the polygon
\item \code{rings}: List of coordinate rings, where each ring is a list
of \verb{[x, y]} coordinate pairs. The first ring is the exterior
boundary; subsequent rings (if present) are holes.
}
}
\description{
Converts \code{sf} polygon or multipolygon geometries into a list
structure containing coordinate arrays, suitable for serialization
to JSON or use in JavaScript visualizations. Preserves both
exterior rings and holes.
}
\details{
This function is primarily used to prepare spatial data for
client-side rendering in web applications. Each polygon may contain
multiple rings (exterior + holes), and multipolygons are decomposed
into separate ring lists.

The output format is compatible with JavaScript mapping libraries
and SVG path generation.
}
\examples{
\dontrun{
library(sf)

# Create a simple polygon
poly <- st_polygon(list(
  matrix(c(0,0, 1,0, 1,1, 0,1, 0,0), ncol = 2, byrow = TRUE)
))
sf_obj <- st_sf(id = "test", geometry = st_sfc(poly))

# Extract coordinates
coords <- polygons_from_sf(sf_obj, id_col = "id")
str(coords)
}

}
\seealso{
\code{\link[=lines_from_sf]{lines_from_sf()}}, \code{\link[=points_from_sf]{points_from_sf()}}, \code{\link[=shiny_fisheye]{shiny_fisheye()}}
}
\keyword{internal}
