% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_car.R
\name{mc_car}
\alias{mc_car}
\title{Conditional Autoregressive Model Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_car(list_neigh, intrinsic = FALSE)
}
\arguments{
\item{list_neigh}{list of neighboors.}

\item{intrinsic}{logical.}
}
\value{
A list of a matrix (\code{intrinsic = TRUE}) or two matrices
(\code{intrinsic = FALSE}). The main use of these matrices are as input in the
\code{mcglm} function as linear covariance models in the argument \code{matrix_pred}.
}
\description{
The function \code{mc_car} helps to build the components
of the matrix linear predictor used for fitting conditional
autoregressive models. This function is used in general for fitting
spatial areal data using the well known conditional autoregressive
models (CAR). This function depends on a list of neighboors, such a
list can be constructed, for example using the
\code{tri2nb} function from the \code{spdep} package
based on spatial coordinates. This way to specify the matrix linear
predictor can also be applied for spatial continuous data,
as an approximation.
}
\seealso{
\code{mc_id}, \code{mc_compute_rho}, \code{mc_conditional_test},
 \code{mc_dist}, \code{mc_ma}, \code{mc_rw} \cr and \code{mc_mixed}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
