% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_pearson.R
\name{mc_pearson}
\alias{mc_pearson}
\title{Pearson Estimating Function}
\source{
Bonat, W. H. and Jørgensen, B. (2016). Multivariate covariance generalized
linear models. Journal of the Royal Statistical Society: Series C,
65, 649--675.
}
\usage{
mc_pearson(
  y_vec,
  mu_vec,
  Cfeatures,
  inv_J_beta = NULL,
  D = NULL,
  correct = FALSE,
  compute_sensitivity = TRUE,
  compute_variability = FALSE,
  W
)
}
\arguments{
\item{y_vec}{Numeric vector of observed responses stacked across
response variables.}

\item{mu_vec}{Numeric vector of fitted means corresponding to
\code{y_vec}.}

\item{Cfeatures}{A list containing covariance-related components,
typically including the covariance matrix \code{C}, its inverse
\code{inv_C}, and the derivatives of \code{C} with respect to the
dispersion parameters (\code{D_C}).}

\item{inv_J_beta}{Optional matrix giving the inverse of the sensitivity
matrix associated with the regression parameters. Required only when
bias correction is requested.}

\item{D}{Optional matrix of derivatives of the mean vector with respect
to the regression parameters. Required only when bias correction is
requested.}

\item{correct}{Logical indicating whether the bias-corrected Pearson
estimating function should be computed. Defaults to \code{FALSE}.}

\item{compute_sensitivity}{Logical indicating whether the sensitivity
matrix of the Pearson estimating function should be computed.
Defaults to \code{TRUE}.}

\item{compute_variability}{Logical indicating whether the variability
matrix of the Pearson estimating function should be computed.
Defaults to \code{FALSE}.}

\item{W}{Numeric vector or diagonal matrix of weights associated with
the observations.}
}
\value{
A list with the following components:
\describe{
  \item{Score}{A numeric vector containing the values of the Pearson
  estimating function for the dispersion parameters.}
  \item{Sensitivity}{A matrix giving the sensitivity (expected Jacobian)
  of the Pearson estimating function. Returned only if
  \code{compute_sensitivity = TRUE}.}
  \item{Variability}{A matrix giving the variability of the Pearson
  estimating function. Returned only if
  \code{compute_variability = TRUE}.}
  \item{Extra}{A list of intermediate quantities used in the
  computation, mainly products involving derivatives of the covariance
  matrix.}
}
}
\description{
Computes the Pearson estimating function for the dispersion parameters
in multivariate covariance generalized linear models, together with its
associated sensitivity and variability matrices. This function is used
internally in the estimating function framework adopted by
\code{mcglm}.
}
\details{
The Pearson estimating function is based on quadratic forms of the
residuals and the inverse covariance matrix. When
\code{correct = TRUE}, a bias-corrected version is computed using the
correction term described in Bonat and Jørgensen (2016). The sensitivity
and variability matrices correspond to Equations (6), (7) and (8) of
that reference.

This function is intended for internal use and is not designed to be
called directly by end users.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
