% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taildep.R
\name{kjtail}
\alias{kjtail}
\title{Estimators of the tail coefficient}
\usage{
kjtail(
  xdat,
  qlev,
  ptail = NULL,
  mqu = NULL,
  type = 1,
  ties.method = eval(formals(rank)$ties.method),
  ...
)
}
\arguments{
\item{xdat}{a matrix of observations}

\item{qlev}{vector of quantile levels}

\item{ptail}{tail probability smaller than \code{qlev}. Default to \code{NULL}}

\item{mqu}{marginal quantile levels for semiparametric estimation; data above this are modelled using a generalized Pareto distribution. If \code{NULL}, empirical estimation is used throughout}

\item{type}{integer indicating the estimator type}

\item{ties.method}{method for handling of ties in rank transformation}

\item{...}{additional arguments, for backward compatibility}
}
\value{
a list with elements
\itemize{
\item \code{p} quantile level for estimation
\item \code{eta} matrix of estimated coefficient of tail dependence \eqn{\eta}, and standard errors
\item \code{k1} parameter of the tail expansion
\item \code{pat} proportion of observations above the threshold
\item \code{lambda} tail dependence coefficient (sic)
\item \code{tailprob} tail probability, if \code{ptail} is provided
}
}
\description{
Estimators proposed by Krupskii and Joe under second order expansion
for the coefficient of tail dependence \eqn{\eta} and the
joint tail orthant probability
}
\note{
EXPERIMENTAL. The numerical optimization of the likelihood surface is
difficult, as the function is ill-behaved. Visual inspection of estimates is
often necessary to check for possible lack of convergence.
}
\examples{
d <- 2
rho <- 0.9
Sigma <- matrix(rho, d, d) + diag(1 - rho, d)
eta_true <- 1/sum(Sigma)
data <- rmnorm(
   n = 1e4,
   mu = rep(0, d),
  Sigma = Sigma)
q <- seq(0.95, 0.995, by = 0.005)
kj <- kjtail(xdat = data, qlev = q)
plot(kj)
abline(h = (1+rho)/2, col = 2)
}
