% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{mfcurve_plotting}
\alias{mfcurve_plotting}
\title{Create a two-panel mfcurve plot from processed statistics}
\usage{
mfcurve_plotting(
  group_stats_vis,
  lower_data,
  grand_mean,
  outcome,
  factors,
  level,
  rounding = 2,
  showTitle = TRUE,
  plotOrigin = FALSE,
  CI = TRUE,
  mode = "collapsed",
  showGrandMean = TRUE,
  showSigStars = TRUE
)
}
\arguments{
\item{group_stats_vis}{Data frame containing group-level summary statistics.}

\item{lower_data}{Data frame defining the factor structure for the lower panel.}

\item{grand_mean}{Numeric. The overall mean of the outcome variable.}

\item{outcome}{Name of the outcome variable (string).}

\item{factors}{Character vector of factor variable names.}

\item{level}{Level for confidence intervals (e.g., 0.95).}

\item{rounding}{Number of digits to round outcome values. Default is 2.}

\item{showTitle}{Logical. Show the plot title? Default is TRUE.}

\item{plotOrigin}{Logical. Force axes to include 0? Default is FALSE.}

\item{CI}{Logical. Display confidence intervals? Default is TRUE.}

\item{mode}{Labeling mode for the lower panel: "collapsed" (default) or "expanded".}

\item{showGrandMean}{Logical. Show the grand mean overall groups. Default is TRUE.}

\item{showSigStars}{Logical. Flag significant results. Default is TRUE.}
}
\value{
A plotly object (invisible).
}
\description{
Generates an interactive two-panel plot showing group means (with optional confidence intervals)
and corresponding factor combinations.
}
