% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDS_MGWR.R
\name{TDS_MGWR}
\alias{TDS_MGWR}
\title{Top-Down Scale (TDS) and Adaptive Top-Down Scale (ATDS) Estimation for MGWR}
\usage{
TDS_MGWR(formula, data, coords, Model = 'tds_mgwr',
                    kernels = 'gauss', fixed_vars = NULL, Ht = NULL,
                    control_tds = list(nns = 25, get_AIC = FALSE, init_model = "OLS"),
                    control = list(adaptive = TRUE))
}
\arguments{
\item{formula}{A formula object specifying the model (e.g., \code{y ~ x1 + x2}).}

\item{data}{A data frame containing the variables in the model.}

\item{coords}{A matrix or data frame of coordinates (2 columns for spatial).}

\item{Model}{A character string specifying the algorithm. Options:
\itemize{
  \item \code{'tds_mgwr'} (default): Top-Down Scale MGWR (Stage 1 only).
  \item \code{'atds_mgwr'}: Adaptive Top-Down Scale MGWR (Stage 1 + Stage 2 boosting).
  \item \code{'atds_gwr'}: Univariate Adaptive Top-Down Scale GWR.
}}

\item{kernels}{A character string or vector specifying the kernel type (e.g., \code{'triangle'}, \code{'bisq'}, \code{'gauss'}). Default is \code{'triangle'}.}

\item{fixed_vars}{A character vector indicating the names of variables with spatially stationary (fixed) coefficients. Default is \code{NULL}.}

\item{Ht}{Numeric. Optional bandwidth for the second dimension (time) if using spatio-temporal models (Type 'GDT').}

\item{control_tds}{A named list of control parameters specific to the TDS algorithm:
\describe{
  \item{\code{nns}}{Integer. Number of bandwidth steps in the decreasing sequence (default 30).}
  \item{\code{get_AIC}}{Logical. If \code{TRUE}, computes AICc (slower). Default \code{FALSE} (except for \code{'atds_mgwr'}).}
  \item{\code{init_model}}{Character. Initial model type to start backfitting: \code{'OLS'} (default), \code{'GWR'}, \code{'GTWR'}, or \code{'known'}.}
  \item{\code{ncore}}{Integer. Number of cores for parallelization. Default 1.}
  \item{\code{tol}}{Numeric. Convergence tolerance. Default 0.001.}
  \item{\code{nrounds}}{Integer. Number of boosting rounds for Stage 2 (only for \code{'atds_mgwr'}). Default 3.}
}}

\item{control}{A named list of standard control arguments passed to the internal \code{MGWRSAR} calls:
\describe{
  \item{\code{adaptive}}{Logical or Vector. \code{TRUE} for adaptive bandwidth (nearest neighbors), \code{FALSE} for fixed distance. Can be a vector of length 2 for space/time.}
  \item{\code{Type}}{Character. Spatial weighting type: \code{'GD'} (Spatial only) or \code{'GDT'} (Space-Time).}
  \item{\code{NN}}{Integer. Maximum number of neighbors for distance matrix computation (truncation). Default is \code{nrow(data)}.}
}}
}
\value{
An object of class \code{mgwrsar} containing:
\item{Betav}{Matrix of spatially varying coefficients.}
\item{H}{Vector of optimal bandwidths found for each covariate.}
\item{RMSE}{Root Mean Square Error of the final model.}
\item{AICc}{Corrected Akaike Information Criterion (if requested).}
\item{fitted.values}{Vector of fitted values.}
\item{residuals}{Vector of residuals.}
}
\description{
This function implements the "Top-Down Scale" (TDS) methodology for estimating
Multiscale Geographically Weighted Regression (MGWR) models.
Unlike classical backfitting approaches that fully optimize bandwidths at each iteration, TDS uses a pre-defined sequence of decreasing bandwidths
to efficiently identify the optimal spatial scale for each covariate.

The function supports two main algorithms:
\itemize{
  \item \strong{'tds_mgwr'}: A backfitting algorithm that selects a unique optimal bandwidth for each covariate from a decreasing sequence.
  \item \strong{'atds_mgwr'}: Extends 'tds_mgwr' with a second "boosting" stage (Adaptive TDS). It refines estimates by allowing bandwidths to vary locally, capturing complex spatial patterns (e.g., simultaneous large-scale trends and local variations).
}
}
\details{
The TDS algorithm works in two stages:
\enumerate{
  \item **Stage 1 (Backfitting):** Starts with a global model (OLS) or a simple GWR. It iteratively updates the bandwidth for each covariate by testing values from a decreasing sequence. This avoids the "yo-yo" effect of standard backfitting and converges faster.
  \item **Stage 2 (Boosting - atds_mgwr only):** Uses the residuals from Stage 1 to iteratively refine coefficients. This stage allows the effective bandwidth to adapt locally, improving accuracy for covariates with spatially heterogeneous scales.
}
}
\references{
Geniaux, G. (2024). Top-Down Scale Approaches for Multiscale GWR with Locally Adaptive Bandwidths. \emph{Springer Nature}.
}
\seealso{
\code{\link{MGWRSAR}}, \code{\link{golden_search_bandwidth}}
}
