% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{markmapOption}
\alias{markmapOption}
\title{Theme options for markmap creation}
\usage{
markmapOption(
  preset = NULL,
  nodeHeight = 20,
  nodeWidth = 180,
  spacingVertical = 10,
  spacingHorizontal = 120,
  duration = 750,
  layout = "tree",
  color = "gray",
  linkShape = "diagonal",
  renderer = "boxed",
  ...
)
}
\arguments{
\item{preset}{the name of built-in theme for markmap. If present, any other parameters will be ignored.}

\item{nodeHeight}{the height of nodes in the markmap.}

\item{nodeWidth}{the width of nodes in the markmap.}

\item{spacingVertical}{space of vertical.}

\item{spacingHorizontal}{space of horizontal.}

\item{duration}{duration time for animation.}

\item{layout}{layout mode of markmap. Currently, only 'tree' is accepted.}

\item{color}{color of markmap. A character color value ,either 'gray' or a categorical colors including 'category10','category20','category20b' and 'category20c'.}

\item{linkShape}{link shape of markmap. A character value, either 'diagonal' or 'bracket'.}

\item{renderer}{rendered shaped of markmap. A character value ,either 'basic' or 'boxed'.}

\item{...}{other options.}
}
\value{
A list of settings for mind map widget.
}
\description{
Theme options for markmap creation
}
\details{
This function is adapted from the \href{https://github.com/seifer08ms/Rmarkmap}{Rmarkup} package.

Currently, markmap have 'default' and 'colorful' themes.
}
\seealso{
\url{https://github.com/seifer08ms/Rmarkmap} and \url{https://github.com/dundalek/markmap/blob/master/lib/view.mindmap.js} for details.
}
