% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{http_config}
\alias{http_config}
\title{HTTP Remote Launch Configuration}
\usage{
http_config(
  url = posit_workbench_url,
  method = "POST",
  cookie = posit_workbench_cookie,
  token = NULL,
  data = posit_workbench_data
)
}
\arguments{
\item{url}{(character or function) URL endpoint for the launch API. May be a
function returning the URL value.}

\item{method}{(character) HTTP method, typically \code{"POST"}.}

\item{cookie}{(character or function) session cookie value. May be a
function returning the cookie value. Set to \code{NULL} if not required for
authentication.}

\item{token}{(character or function) authentication bearer token. May be a
function returning the token value. Set to \code{NULL} if not required for
authentication.}

\item{data}{(character or function) JSON or formatted request body containing
the daemon launch command. May be a function returning the data value.
Should include a placeholder \code{"\%s"} where the \code{mirai::daemon()} call
will be inserted at launch time.}
}
\value{
A list in the required format to be supplied to the \code{remote} argument
of \code{\link[=daemons]{daemons()}} or \code{\link[=launch_remote]{launch_remote()}}.
}
\description{
Generates a remote configuration for launching daemons via HTTP API. By
default, automatically configures for Posit Workbench using environment
variables.
}
\examples{
tryCatch(http_config(), error = identity)

# Custom HTTP configuration example:
http_config(
  url = "https://api.example.com/launch",
  method = "POST",
  cookie = function() Sys.getenv("MY_SESSION_COOKIE"),
  token = function() Sys.getenv("MY_API_KEY"),
  data = '{"command": "\%s"}'
)

\dontrun{
# Launch 2 daemons using http config default (for Posit Workbench):
daemons(n = 2, url = host_url(), remote = http_config())
}

}
\seealso{
\code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}} and \code{\link[=remote_config]{remote_config()}} for other
types of remote configuration.
}
