% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-liftover.R
\name{gintervals.as_chain}
\alias{gintervals.as_chain}
\title{Transforms existing intervals to a chain format}
\usage{
gintervals.as_chain(
  intervals = NULL,
  src_overlap_policy = "error",
  tgt_overlap_policy = "auto",
  min_score = NULL
)
}
\arguments{
\item{intervals}{a data frame with chain columns: chrom, start, end, strand,
chromsrc, startsrc, endsrc, strandsrc, chain_id, score}

\item{src_overlap_policy}{source overlap policy: "error", "keep", or "discard"}

\item{tgt_overlap_policy}{target overlap policy: "error", "auto", "auto_first",
"auto_longer", "auto_score", "discard", "keep", or "agg"}

\item{min_score}{optional minimum alignment score threshold}
}
\value{
A data frame in chain format with chain attributes set
}
\description{
Transforms existing intervals to a chain format by validating required columns
and adding chain attributes.
}
\details{
This function checks that the input intervals data frame has all the required
columns for a chain format and adds the necessary attributes. A chain format
requires both target coordinates (chrom, start, end, strand) and source
coordinates (chromsrc, startsrc, endsrc, strandsrc), as well as chain_id and
score columns.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

# Create a chain from existing intervals
chain_data <- data.frame(
    chrom = "chr1",
    start = 1000,
    end = 2000,
    strand = 0,
    chromsrc = "chr1",
    startsrc = 5000,
    endsrc = 6000,
    strandsrc = 0,
    chain_id = 1L,
    score = 1000.0
)
chain <- gintervals.as_chain(chain_data)

}
\seealso{
\code{\link{gintervals.load_chain}}, \code{\link{gintervals.liftover}}
}
\keyword{~chain}
\keyword{~intervals}
\keyword{~liftover}
