% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-management.R
\name{gtrack.rm}
\alias{gtrack.rm}
\title{Deletes a track}
\usage{
gtrack.rm(track = NULL, force = FALSE, db = NULL)
}
\arguments{
\item{track}{track name}

\item{force}{if 'TRUE', suppresses user confirmation of a named track removal}

\item{db}{optional database path to delete the track from when multiple
databases are connected}
}
\value{
None.
}
\description{
Deletes a track.
}
\details{
This function deletes a track from the Genomic Database. By default
'gtrack.rm' requires the user to interactively confirm the deletion. Set
'force' to 'TRUE' to suppress the user prompt.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.create("new_track", "Test track", "2 * dense_track")
gtrack.exists("new_track")
gtrack.rm("new_track", force = TRUE)
gtrack.exists("new_track")

}
\seealso{
\code{\link{gtrack.exists}}, \code{\link{gtrack.ls}},
\code{\link{gtrack.create}}, \code{\link{gtrack.2d.create}},
\code{\link{gtrack.create_sparse}}, \code{\link{gtrack.smooth}}
}
\keyword{~track}
