% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.indicator.R
\name{na.indicator}
\alias{na.indicator}
\title{Missing Data Indicator Matrix}
\usage{
na.indicator(data, ..., na = 1, append = TRUE, name = ".i", as.na = NULL,
             check = TRUE)
}
\arguments{
\item{data}{a data frame with incomplete data, where missing
values are coded as \code{NA}.}

\item{...}{an expression indicating the variable names in \code{data}, e.g.,
\code{na.indicator(dat, x1, x2, x3)}. Note that the operators
\code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{na}{an integer value specifying the value representing missing values,
i.e., either \code{na = 0} for \code{0 = missing} and
\code{1 = observed}, or \code{na = 1} (default) for \code{0} (observed)
and \code{1 = missing}.}

\item{append}{logical: if \code{TRUE} (default), missing data indicator matrix
is appended to the data frame specified in the argument \code{data}.}

\item{name}{a character string indicating the name suffix of indicator variables
By default, the indicator variables are named with the ending
\code{".i"} resulting in e.g. \code{"x1.i"} and \code{"x2.i"}.
Note that when selecting one single variable, the indicator variable
is named \code{x.i} by default or named after the argument \code{name}.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a matrix or data frame with \eqn{r = 1} if a value is observed, and \eqn{r = 0}
if a value is missing.
}
\description{
This function creates a missing data indicator matrix \eqn{R} that denotes whether
values are observed or missing, i.e., \eqn{r = 0} if a value is observed, and
\eqn{r = 1} if a value is missing.
}
\examples{
# Example 1: Create missing data indicator matrix
na.indicator(airquality)

# Example 2: Do not append missing data indicator matrix to the data frame
na.indicator(airquality, append = FALSE)
}
\references{
Enders, C. K. (2022). \emph{Applied missing data analysis} (2nd ed.). The Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576.
https://doi.org/10.1146/annurev.psych.58.110405.085530

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.). Chapman & Hall.
}
\seealso{
\code{\link{as.na}}, \code{\link{na.as}}, \code{\link{na.auxiliary}},
\code{\link{na.coverage}}, \code{\link{na.descript}}, \code{\link{na.pattern}},
\code{\link{na.prop}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
