% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calibrateYield}
\alias{calibrateYield}
\title{Calibrate the model scale to match total observed yield}
\usage{
calibrateYield(params)
}
\arguments{
\item{params}{A MizerParams object}
}
\value{
A MizerParams object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
This function has been deprecated and will be removed in the future unless
you have a use case for it. If you do have a use case for it, please let the
developers know by creating an issue at
\url{https://github.com/sizespectrum/mizer/issues}.

Given a MizerParams object \code{params} for which yield observations are
available for at least some species via the \code{yield_observed} column in the
species_params data frame, this function returns an updated MizerParams
object which is rescaled with \code{\link[=scaleModel]{scaleModel()}} so that the total yield in
the model agrees with the total observed yield.

After using this function the total yield in the model will match the
total observed yield, summed over all species. However the yields of the
individual species will not match observations yet, with some species
having yields that are too high and others too low. So after this
function you may want to use \code{\link[=matchYields]{matchYields()}}.

If you have observations of species biomasses instead of yields, you can
use \code{\link[=calibrateBiomass]{calibrateBiomass()}} instead of this function.
}
\examples{
params <- NS_params
species_params(params)$yield_observed <-
    c(0.8, 61, 12, 35, 1.6, 20, 10, 7.6, 135, 60, 30, 78)
gear_params(params)$catchability <-
    c(1.3, 0.065, 0.31, 0.18, 0.98, 0.24, 0.37, 0.46, 0.18, 0.30, 0.27, 0.39)
params2 <- calibrateYield(params)
plotYieldObservedVsModel(params2)
}
\concept{deprecated}
