% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskRegr_fuel.R
\name{mlr_tasks_fuel}
\alias{mlr_tasks_fuel}
\title{Fuel Regression Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link[mlr3:TaskRegr]{mlr3::TaskRegr}.
}
\description{
This dataset contains two functional covariates and one scalar covariate. The goal is
to predict the heat value of some fuel based on the ultraviolet radiation spectrum and
infrared ray radiation and one scalar column called h2o.

This is a subset of the full dataset, which is contained in the package \code{FDboost}.
}
\section{Dictionary}{

This \link[mlr3:Task]{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_tasks]{mlr_tasks}
or with the associated sugar function \link[mlr3:mlr_sugar]{tsk()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("fuel")
tsk("fuel")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Dimensions: 129x4
\item Properties: -
\item Has Missings: \code{FALSE}
\item Target: \dQuote{heatan}
\item Features: \dQuote{NIR}, \dQuote{UVVIS}, \dQuote{h20}
}
}

\references{
Brockhaus, Sarah, Scheipl, Fabian, Hothorn, Torsten, Greven, Sonja (2015).
\dQuote{The functional linear array model.}
\emph{Statistical Modelling}, \bold{15}(3), 279--300.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Task]{Tasks}: \link[mlr3:mlr_tasks]{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[mlr3:Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{mlr_tasks_dti}},
\code{\link{mlr_tasks_phoneme}}
}
\concept{Task}
