% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{autoplot.Filter}
\alias{autoplot.Filter}
\title{Plots for Filter Scores}
\usage{
\method{autoplot}{Filter}(object, type = "boxplot", n = Inf, theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link[mlr3filters:Filter]{mlr3filters::Filter}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{n}{(\code{integer(1)})\cr
Only include the first \code{n} features with the highest importance.
Defaults to all features.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3filters:Filter]{mlr3filters::Filter}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"barplot"} (default): Bar plot of filter scores.
}
}
\examples{
if (mlr3misc::require_namespaces("mlr3filters", quietly = TRUE)) {
library(mlr3filters)

task = tsk("mtcars")
f = flt("correlation")
f$calculate(task)

head(fortify(f))
autoplot(f, n = 5)
}
}
