% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPCbinareas.R
\name{OPCbinareas}
\alias{OPCbinareas}
\title{Visualize surface area distribution into separate OPC orientation bins.}
\usage{
OPCbinareas(
  OPC_File,
  main = "",
  binColors = hsv(h = (seq(10, 290, 40)/360), s = 0.9, v = 0.85),
  type = "bar"
)
}
\arguments{
\item{OPC_File}{An object that stores the output
of an OPC analysis using \code{OPC()}.}

\item{main}{Title for plot.}

\item{binColors}{Allows the user to define the fill colors for
each directional bin. see details}

\item{type}{String argument to determine type of plot, either
bar' or 'pie'. Default is set to 'bar'}
}
\description{
This function will make either a bar plot or pie
chart showing the surface area assigned to each
OPC orientation bin.
}
\details{
This function will create either bar or pie chats visualising
the distribution of surface area into each of the OPC orientation
bins. Colors can be customized but are meant to match the
default settings in the \code{OPC3d()} function.
}
\examples{
OPC_Object <- OPC(Tooth)
OPCbinareas(OPC_Object) 
}
