% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_covs.R
\name{compute_univariate_sumstats}
\alias{compute_univariate_sumstats}
\title{Compute summary statistics from univariate simple linear regression.}
\usage{
compute_univariate_sumstats(
  X,
  Y,
  standardize = FALSE,
  standardize.response = FALSE,
  mc.cores = 1
)
}
\arguments{
\item{X}{n x p matrix of covariates.}

\item{Y}{n x r matrix of responses.}

\item{standardize}{If \code{TRUE}, X is "standardized" using the
sample means and sample standard deviations.}

\item{standardize.response}{If \code{TRUE}, Y is "standardized" using the
sample means and sample standard deviations.}

\item{mc.cores}{Number of cores to use. Parallelization is done over responses.}
}
\value{
A list with following elements:

\item{Bhat}{p x r matrix of the regression coeffcients.}

\item{Shat}{p x r matrix of the standard errors for regression coeffcients.}
}
\description{
Function to compute regression coefficients and their standard errors
  from univariate simple linear regression.
}
