% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{SimpleTreeView}
\alias{SimpleTreeView}
\title{SimpleTreeView}
\usage{
SimpleTreeView(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/x/api/tree-view/simple-tree-view/}
}
\details{
\itemize{
\item apiRef \verb{\{ current?: \{ focusItem?: func, getItem?: func, getItemDOMElement?: func, getItemOrderedChildrenIds?: func, getItemTree?: func, getParentId?: func, isItemExpanded?: func, setIsItemDisabled?: func, setItemExpansion?: func, setItemSelection?: func \} \}} \cr Default is - The ref object that allows Tree View manipulation. Can be instantiated with useTreeViewApiRef().
\item checkboxSelection \code{bool} \cr Default is FALSE If true, the Tree View renders a checkbox at the left of its label that allows selecting it.
\item children \code{node} \cr Default is - The content of the component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item defaultExpandedItems \verb{Array string } \cr Default is [] Expanded item ids. Used when the item's expansion is not controlled.
\item defaultSelectedItems \code{any} \cr Default is [] Selected item ids. (Uncontrolled) When multiSelect is true this takes an array of strings; when false (default) a string.
\item disabledItemsFocusable \code{bool} \cr Default is FALSE If true, will allow focus on disabled items.
\item disableSelection \code{bool} \cr Default is FALSE If true selection is disabled.
\item expandedItems \verb{Array string } \cr Default is - Expanded item ids. Used when the item's expansion is controlled.
\item expansionTrigger \verb{'content'| 'iconContainer'} \cr Default is 'content' The slot that triggers the item's expansion when clicked.
\item id \code{string} \cr Default is - This prop is used to help implement the accessibility logic. If you don't provide this prop. It falls back to a randomly generated id.
\item itemChildrenIndentation \verb{number| string} \cr Default is 12px Horizontal indentation between an item and its children. Examples: 24, "24px", "2rem", "2em".
\item multiSelect \code{bool} \cr Default is FALSE If true, ctrl and shift will trigger multiselect.
\item onExpandedItemsChange \code{func} \cr Default is - Callback fired when Tree Items are expanded/collapsed.Signature:function(event: React.SyntheticEvent, itemIds: array) =  voidevent The DOM event that triggered the change. Can be null when the change is caused by the publicAPI.setItemExpansion() method.itemIds The ids of the expanded items.
\item onItemClick \code{func} \cr Default is - Callback fired when the content slot of a given Tree Item is clicked.Signature:function(event: React.MouseEvent, itemId: string) =  voidevent The DOM event that triggered the change.itemId The id of the focused item.
\item onItemExpansionToggle \code{func} \cr Default is - Callback fired when a Tree Item is expanded or collapsed.Signature:function(event: React.SyntheticEvent | null, itemId: array, isExpanded: boolean) =  voidevent The DOM event that triggered the change. Can be null when the change is caused by the publicAPI.setItemExpansion() method.itemId The itemId of the modified item.isExpanded true if the item has just been expanded, false if it has just been collapsed.
\item onItemFocus \code{func} \cr Default is - Callback fired when a given Tree Item is focused.Signature:function(event: React.SyntheticEvent | null, itemId: string) =  voidevent The DOM event that triggered the change. Warning: This is a generic event not a focus event.itemId The id of the focused item.
\item onItemSelectionToggle \code{func} \cr Default is - Callback fired when a Tree Item is selected or deselected.Signature:function(event: React.SyntheticEvent, itemId: array, isSelected: boolean) =  voidevent The DOM event that triggered the change. Can be null when the change is caused by the publicAPI.setItemSelection() method.itemId The itemId of the modified item.isSelected true if the item has just been selected, false if it has just been deselected.
\item onSelectedItemsChange \code{func} \cr Default is - Callback fired when Tree Items are selected/deselected.Signature:function(event: React.SyntheticEvent, itemIds: Array | string) =  voidevent The DOM event that triggered the change. Can be null when the change is caused by the publicAPI.setItemSelection() method.itemIds The ids of the selected items. When multiSelect is true, this is an array of strings; when false (default) a string.
\item selectedItems \code{any} \cr Default is - Selected item ids. (Controlled) When multiSelect is true this takes an array of strings; when false (default) a string.
\item selectionPropagation \verb{\{ descendants?: bool, parents?: bool \}} \cr Default is  parents: FALSE, descendants: FALSE  When selectionPropagation.descendants is set to true.- Selecting a parent selects all its descendants automatically. - Deselecting a parent deselects all its descendants automatically.When selectionPropagation.parents is set to true.- Selecting all the descendants of a parent selects the parent automatically. - Deselecting a descendant of a selected parent deselects the parent automatically.Only works when multiSelect is true. On the  SimpleTreeView / , only the expanded items are considered (since the collapsed item are not passed to the Tree View component at all)
\item slotProps \code{object} \cr Default is - The props used for each component slot.
\item slots \code{object} \cr Default is - Overridable component slots.See Slots API below for more details.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
}
}
