% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancorr.R
\name{cancorr}
\alias{cancorr}
\title{Canonical correlation analysis}
\usage{
cancorr(
  X_vars,
  Y_vars,
  data = NULL,
  Cov = NULL,
  numObs = NULL,
  model = c("CORR-W", "CORR-L", "COV-W", "COV-L"),
  extraTries = 50,
  ...
)
}
\arguments{
\item{X_vars}{A vector of characters of the X variables.}

\item{Y_vars}{A vector of characters of the Y variables.}

\item{data}{A data frame containing raw data. If NULL, \code{Cov} and
\code{numObs} must be provided.}

\item{Cov}{A covariance or correlation matrix. Required when \code{data} is NULL.}

\item{numObs}{A sample size. Required when \code{data} is NULL.}

\item{model}{Four models defined in Gu, Yung, and Cheung (2019).
\code{CORR} and \code{COV} refer to analyses of correlation structures and
covariance structures, respectively.}

\item{extraTries}{This function calls \code{\link[OpenMx:mxTryHard]{OpenMx::mxTryHard()}} to obtain
parameter estimates and their standard errors. \code{extraTries} is the
number of extra runs. If \code{extraTries=0}, \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}} is
called.}

\item{...}{Additional arguments passed to either
\code{\link[OpenMx:mxTryHard]{OpenMx::mxTryHard()}} or \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}}.}
}
\value{
A list with class \code{CanCorr}. It stores the model in OpenMx
objects. The fitted object is stored in \code{mx.fit}.
}
\description{
This function conducts canonical correlation analysis using the OpenMx
package. Missing data are handled with the full information maximum
likelihood method when raw data are available. It provides standard
errors for the estimates.
}
\note{
\code{cancorr} expects the number of variables in \code{Y_vars} to be
equal to or greater than that in \code{X_vars}. If there are fewer in
\code{Y_vars}, you may swap between \code{X_vars} and \code{Y_vars}.
}
\examples{
\donttest{
## Canonical Correlation Analysis
cancorr(X_vars=c("Weight", "Waist", "Pulse"),
        Y_vars=c("Chins", "Situps", "Jumps"),
        data=sas_ex1)
}
}
\references{
Gu, F., Yung, Y.-F., & Cheung, M. W.-L. (2019). Four covariance
structure models for canonical correlation analysis: A COSAN modeling
approach. \emph{Multivariate Behavioral Research}, \strong{54(2)},
192-223. \doi{10.1080/00273171.2018.1512847}
}
\seealso{
\link{Thorndike00}, \link{sas_ex1}
}
\author{
Mike W.-L. Cheung \href{mailto:mikewlcheung@nus.edu.sg}{mikewlcheung@nus.edu.sg}
}
