% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCensusData.R
\name{getCityData}
\alias{getCityData}
\title{Get City Population Data by Age}
\usage{
getCityData(
  city_name,
  csv_path,
  age_groups = c(0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85),
  verbose = FALSE
)
}
\arguments{
\item{city_name}{Name of the city (e.g., "Hildale city, Utah")}

\item{csv_path}{Path to the city population CSV file}

\item{age_groups}{Vector of age limits for grouping. If NULL, returns single-year ages
(disaggregated from 5-year ACS groups). Default uses 5-year intervals: c(0,5,10,...,85)}

\item{verbose}{Logical, if TRUE prints messages about age aggregation. Default is FALSE.}
}
\value{
A list containing:
\item{city}{City name}
\item{year}{Data year}
\item{total_pop}{Total population}
\item{age_pops}{Vector of populations by age group}
\item{age_labels}{Labels for each age group}
\item{data}{Full data frame}
}
\description{
Reads and processes population data for specific cities from ACS 5-year estimates,
organized by age groups. The ACS data provides 5-year age groupings (0-4, 5-9, etc.)
which can be disaggregated into single-year ages or aggregated into custom age groups.
}
\examples{
# Load Hildale data with default 5-year age groups
hildale_data <- getCityData(
  city_name = "Hildale city, Utah",
  csv_path = system.file("extdata", "hildale_ut_2023.csv", package = "multigroup.vaccine")
)

# Load with single-year ages (disaggregated)
hildale_single <- getCityData(
  city_name = "Hildale city, Utah",
  csv_path = system.file("extdata", "hildale_ut_2023.csv", package = "multigroup.vaccine"),
  age_groups = NULL
)

# Load with custom age groups
hildale_custom <- getCityData(
  city_name = "Hildale city, Utah",
  csv_path = system.file("extdata", "hildale_ut_2023.csv", package = "multigroup.vaccine"),
  age_groups = c(0, 18, 65)
)
}
