% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.mvgam.R
\name{irf.mvgam}
\alias{irf.mvgam}
\alias{irf}
\title{Calculate latent VAR impulse response functions}
\usage{
irf(object, ...)

\method{irf}{mvgam}(object, h = 10, cumulative = FALSE, orthogonal = FALSE, ...)
}
\arguments{
\item{object}{\code{list} object of class \code{mvgam} resulting from a call to \code{\link[=mvgam]{mvgam()}}
that used a Vector Autoregressive latent process model (either as \code{VAR(cor = FALSE)} or
\code{VAR(cor = TRUE)}; see \code{\link[=VAR]{VAR()}} for details)}

\item{...}{ignored}

\item{h}{Positive \code{integer} specifying the forecast horizon over which to calculate
the IRF}

\item{cumulative}{\code{Logical} flag indicating whether the IRF should be cumulative}

\item{orthogonal}{\code{Logical} flag indicating whether orthogonalized IRFs should be
calculated. Note that the order of the variables matters when calculating these}
}
\value{
An object of \code{\link{mvgam_irf-class}} containing the posterior IRFs. This
object can be used with the supplied S3 functions \code{\link[=plot.mvgam_irf]{plot.mvgam_irf()}}
and \code{\link[=summary.mvgam_irf]{summary.mvgam_irf()}}
}
\description{
Compute Generalized or Orthogonalized Impulse Response Functions (IRFs) from
\code{mvgam} models with Vector Autoregressive dynamics
}
\details{
See \code{\link{mvgam_irf-class}} for a full description of the quantities that are
computed and returned by this function, along with key references.
}
\examples{
\dontrun{
# Fit a model to the portal time series that uses a latent VAR(1)
mod <- mvgam(
  formula = captures ~ -1,
  trend_formula = ~ trend,
  trend_model = VAR(cor = TRUE),
  family = poisson(),
  data = portal_data,
  chains = 2,
  silent = 2
)

# Plot the autoregressive coefficient distributions;
# use 'dir = "v"' to arrange the order of facets
# correctly
mcmc_plot(
  mod,
  variable = 'A',
  regex = TRUE,
  type = 'hist',
  facet_args = list(dir = 'v')
)

# Calulate Generalized IRFs for each series
irfs <- irf(
  mod,
  h = 12,
  cumulative = FALSE
)

# Plot them
plot(irfs, series = 1)
plot(irfs, series = 2)
plot(irfs, series = 3)
plot(irfs, series = 4)

# Calculate posterior median, upper and lower 95th quantiles
# of the impulse responses
summary(irfs)
}
}
\seealso{
\code{\link{mvgam_irf-class}}, \code{\link[=VAR]{VAR()}}, \code{\link[=plot.mvgam_irf]{plot.mvgam_irf()}}, \code{\link[=stability]{stability()}}, \code{\link[=fevd]{fevd()}}
}
\author{
Nicholas J Clark
}
